<?php
/**
* HTMLե४֥ȤΥեȥꥯ饹
*
* PHP version 5
*
* @package    html_objects
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class HTMLFormFactory
{
	private $_form_model;

	/*
	 *	ե४֥Ȥ
	 */
	private static function _createForm( IFormModel $model, $id )
	{
		// ե४֥Ȥ
		$action  = $model->getFormAnnotationValue( 'action' );
		$method  = $model->getFormAnnotationValue( 'method' );
		$target  = $model->getFormAnnotationValue( 'target' );
		$class   = $model->getFormAnnotationValue( 'class' );
		$style   = $model->getFormAnnotationValue( 'style' );

		// APP_URLŸ
		$app_url = Profile::getString( 'APP_URL' );
		$action = str_replace( '{APP_URL}', "$app_url", $action );

		$attributes = array();
		$attributes['id'] = $id;
		$attributes['action'] = $action;
		$attributes['method'] = $method;
		$attributes['target'] = $target;
		$attributes['class'] = $class;
		$attributes['style'] = $style;

		$form = new HTMLFormObject( $attributes );

		return $form;
	}

	/*
	 *	ѥͥ
	 */
	private static function _createPanel( IFormModel $model, $id, $panel_name )
	{
		$layout  = $model->getAnnotationValue( $panel_name, 'layout' );
		$class   = $model->getAnnotationValue( $panel_name, 'class' );
		$style   = $model->getAnnotationValue( $panel_name, 'style' );

		$attributes = array();
		$attributes['id'] = $id;
		$attributes['class'] = $class;
		$attributes['style'] = $style;

		$panel = new HTMLPanelObject( $layout, $attributes );

		return $panel;
	}

	/*
	 *	ץ
	 */
	private static function _createCaption( IFormModel $model, $id, $field, $caption, HTMLPanelObject $panel )
	{
		$default_caption_class = $model->getDefaultCaptionClass();
		$default_caption_style = $model->getDefaultCaptionStyle();
		$class = $model->getAnnotationValue( $field, 'caption_class' );
		$style = $model->getAnnotationValue( $field, 'caption_style' );

		$attributes = array();
		$attributes['id'] = $id;
		$attributes['class'] = $class ? $class : $default_caption_class;
		$attributes['style'] = $style ? $style : $default_caption_style;

		$text = new HTMLTextObject( $caption, $attributes );

		if ( $text ){
			$panel->addChild( $text );
		}
	}

	/*
	 *	ϥեɤ
	 */
	private static function _createInputField( ProcedureContext $context, IFormModel $model, $id, $field, DTO $dto, HTMLPanelObject $panel )
	{
		// ϥ
		$type = $model->getAnnotationValue( $field, 'input_type' );
		if ( !$type ){
			// ϥפɬ
			return NULL;
		}

		$disabled = $model->getAnnotation( $field, 'disabled' );

		$default_field_class = $model->getDefaultFieldClass($type);
		$default_field_style = $model->getDefaultFieldStyle($type);
		$class = $model->getAnnotationValue( $field, 'class' );
		$style = $model->getAnnotationValue( $field, 'style' );
		$value = $model->getAnnotationValue( $field, 'value' );

		$attributes = array();
		$attributes['id'] = $id;
		$attributes['type'] = $type;
		$attributes['name'] = $field;
		$attributes['class'] = $class ? $class : $default_field_class;
		$attributes['style'] = $style ? $style : $default_field_style;
		$attributes['disabled'] = $disabled ? 'disabled' : NULL;

		$value = $value ? $value : $dto->$field;

		$input = NULL;

		switch ( $type ){
		case 'text':
		case 'password':
			$size = $model->getAnnotationValue( $field, 'size' );
			$attributes['value'] = $value;
			$attributes['size'] = $size;
			$input = new HTMLInputObject( $attributes );
			break;
		case 'submit':
		case 'reset':
			$attributes['value'] = $value;
			$input = new HTMLInputObject( $attributes );
			break;
		case 'textarea':
			$cols = $model->getAnnotationValue( $field, 'cols' );
			$rows = $model->getAnnotationValue( $field, 'rows' );
			$attributes['cols'] = $cols;
			$attributes['rows'] = $rows;
			$input = new HTMLTextAreaObject( $value, $attributes );
			break;
		case 'radio':
		case 'checkbox':
			$choice_list_name = $model->getAnnotationValue( $field, 'choice_list' );
			$choice_list = $model->getChoiceList( $context, $choice_list_name );

			$attributes['value'] = $value;
			$attributes['name'] = $field . '[]';

			$checked = $model->getAnnotationValue( $field, 'checked' );
			$check_status = $checked ? explode( ',', $checked ) : NULL;
			$class = $model->getAnnotationValue( $field, 'choice_caption_class' );
			$style = $model->getAnnotationValue( $field, 'choice_caption_style' );

			$caption_attributes = array();
			$caption_attributes['id'] = $id;
			$caption_attributes['class'] = $class ? $class : NULL;
			$caption_attributes['style'] = $style ? $style : NULL;

			$input = new HTMLChoiceGroupObject( $attributes, $caption_attributes, $choice_list, $check_status );
			break;
		case 'select':
			$choice_list_name = $model->getAnnotationValue( $field, 'choice_list' );
			$choice_list = $model->getChoiceList( $context, $choice_list_name );
			$input = new HTMLSelectObject( $attributes, $choice_list, $value );
			break;
		}

		if ( $input ){
			$panel->addChild( $input );
		}
	}

	/*
	 *	ɤ߼ѥեɤ
	 */
	private static function _createStaticField( ProcedureContext $context, IFormModel $model, $id, $field, DTO $dto, HTMLPanelObject $panel )
	{
		// ϥ
		$type = $model->getAnnotationValue( $field, 'input_type' );
		if ( !$type ){
			// ϥפɬ
			return NULL;
		}

		$default_field_class = $model->getDefaultFieldClass($type);
		$default_field_style = $model->getDefaultFieldStyle($type);
		$class = $model->getAnnotationValue( $field, 'class' );
		$style = $model->getAnnotationValue( $field, 'style' );
		$value = $model->getAnnotationValue( $field, 'value' );

		$attributes = array();
		$attributes['id'] = ++$id;
		$attributes['type'] = $type;
		$attributes['name'] = $field;
		$attributes['class'] = $class ? $class : $default_field_class;
		$attributes['style'] = $style ? $style : $default_field_style;

		$value = $value ? $value : $dto->$field;

		$input = NULL;

		switch ( $type ){
		case 'text':
		case 'password':
			$attributes['class'] = NULL;
			$attributes['style'] = NULL;
			$input = new HTMLTextObject( $value, $attributes );
			break;
		case 'submit':
		case 'reset':
			$input = NULL;
			break;
		case 'textarea':
			$attributes['class'] = NULL;
			$attributes['style'] = NULL;
			$text = nl2br($value);
			$input = new HTMLTextObject( $text, $attributes );
			break;
		case 'radio':
		case 'checkbox':
			$choice_list_name = $model->getAnnotationValue( $field, 'choice_list' );
			$choice_list = $model->getChoiceList( $context, $choice_list_name );
			if ( is_array($value) ){
				$caption =NULL;
				foreach( $value as $choice ){
					if ( isset($choice_list[$choice]) ){
						if ( $caption ){
							$caption .= ',&nbsp;';
						}
						$caption .= $choice_list[$choice];
					}
				}
				$input = new HTMLTextObject( $caption, $attributes );
			}
			break;
		case 'select':
			$choice_list_name = $model->getAnnotationValue( $field, 'choice_list' );
			$choice_list = $model->getChoiceList( $context, $choice_list_name );
			$caption = isset($choice_list[$value]) ? $choice_list[$value] : NULL;
			$attributes['class'] = NULL;
			$attributes['style'] = NULL;
			$input = new HTMLTextObject( $caption, $attributes );
			break;
		}

		if ( $input ){
			$panel->addChild( $input );
		}
	}

	/*
	 *	ɽեɤ
	 */
	private static function _createHiddenField( IFormModel $model, $id, $field, DTO $dto, HTMLPanelObject $panel )
	{
		$value = $model->getAnnotationValue( $field, 'value' );

		$value = $value ? $value : $dto->$field;

		$attributes = array();
		$attributes['id'] = ++$id;
		$attributes['type'] = 'hidden';
		$attributes['name'] = $field;
		$attributes['value'] = $value;

		$input = new HTMLInputObject( $attributes );

		$panel->addChild( $input );
	}

	/*
	 *	ե
	 */
	public static function create( ProcedureContext $context, IFormModel $model, DTO $dto, $read_only = FALSE )
	{
		// ID
		$id = 0;

		// ե४֥Ȥ
		$form = self::_createForm( $model, $id );

		// ϥȥɲ
		$input_list = $model->getInputList();
		if ( $input_list ){

			$form_panels = array();

			foreach( $input_list as $field ){

				// ѥͥ
				$panel_name = $model->getAnnotationValue( $field, 'panel' );
				if ( !$panel_name ){
					// ѥͥɬ
					continue;
				}
				if ( !isset($form_panels[$panel_name]) ){
					// ʤк
					$panel = self::_createPanel( $model, $id, $panel_name );
					$form_panels[$panel_name] = $panel;
					$form->addChild( $panel );
				}
				else{
					$panel = $form_panels[$panel_name];
				}

				// ץ
				$caption    = $model->getAnnotationValue( $field, 'caption' );
				$hidden     = $model->getAnnotation( $field, 'hidden' );
				if ( $caption ){
					self::_createCaption( $model, $id++, $field, $caption, $panel );
				}

				// ϥե
				$read_only_field  = $model->getAnnotation( $field, 'read_only' );

				if ( $read_only || ($read_only_field !== NULL) ){
					self::_createStaticField( $context, $model, $id++, $field, $dto, $panel );
				}
				else{
					self::_createInputField( $context, $model, $id++, $field, $dto, $panel );
				}

				$hidden  = $model->getAnnotation( $field, 'hidden' );
				if ( $hidden !== NULL ){
					self::_createHiddenField( $model, $id++, $field, $dto, $panel );
				}
			}
		}

		return $form;
	}

}

return __FILE__;