<?php
/**
* ǡž饹
*
* PHP version 5
*
* @package	core
* @author	 stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class DTO implements Iterator, ArrayAccess
{
	private $_array;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( $array = NULL )
	{
		if ( $array ){
			if ( is_array($array) ){
				$this->_array = $array;
			}
			else{
				throw new NonArrayException($array);
			}
		}
		else{
			$this->_array = array();
		}
	}

	/*
	 *	Iterator󥿥ե:rewidμ
	 */
	public function rewind() {
		reset($this->_array);
	}

	/*
	 *	Iterator󥿥ե:currentμ
	 */
	public function current() {
		$var = current($this->_array);
		return $var;
	}

	/*
	 *	Iterator󥿥ե:keyμ
	 */
	public function key() {
		$var = key($this->_array);
		return $var;
	}

	/*
	 *	Iterator󥿥ե:nextμ
	 */
	public function next() {
		$var = next($this->_array);
		return $var;
	}

	/*
	 *	Iterator󥿥ե:validμ
	 */
	public function valid() {
		$var = $this->current() !== false;
		return $var;
	}

	/*
	 * ץѥƥμ
	 */
	public function get( String $name )
	{
		return isset($this->_array[ "$name" ]) ? $this->_array[ "$name" ] : NULL;
	}

	/*
	 * ץѥƥ
	 */
	public function set( String $name, $value )
	{
		$this->_array[ "$name" ] = $value;
	}

	/*
	 * ץѥƥμ
	 */
	public function __get( $name )
	{
		return isset($this->_array[ $name ]) ? $this->_array[ $name ] : NULL;
	}

	/*
	 * ץѥƥ
	 */
	public function __set( $name, $value )
	{
		$this->_array[ $name ] = $value;
	}

	/*
	 *	ArrayAccess󥿥ե:offsetGetμ
	 */
	public function offsetGet($offset)
	{
if ( !is_string($offset) ){
	throw new NonStringException( $offset );
}
		return isset($this->_array[ $offset ]) ? $this->_array[ $offset ] : NULL;
	}

	/*
	 *	ArrayAccess󥿥ե:offsetSetμ
	 */
	public function offsetSet($offset, $value)
	{
		$this->_array[ $offset ] = $value;
	}

	/*
	 *	ArrayAccess󥿥ե:offsetExistsμ
	 */
	public function offsetExists($offset)
	{
		return isset($this->_array[$offset]);
	}

	/*
	 *	ArrayAccess󥿥ե:offsetUnsetμ
	 */
	public function offsetUnset($offset)
	{
		unset($this->_array[$offset]);
	}


	/*
	 * ʸ
	 */
	public function __toString()
	{
		return '[DTO: ' . System::arrayToString( $this->_array, '&nbsp;', '' ) . ']';
	}

}

return __FILE__;