<?php
/**
* Υեȥɥ󥿥ե
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_Logger 
{
	static $loggers = array();
	static $enabled = FALSE;

	const LOGLEVEL_FATAL     = 100;		// FATAL
	const LOGLEVEL_ERROR     = 200;		// ERROR
	const LOGLEVEL_WARNING   = 300;		// WARNING
	const LOGLEVEL_INFO      = 400;		// INFO
	const LOGLEVEL_DEBUG     = 500;		// DEBUG
	const LOGLEVEL_TRACE     = 600;		// TRACE

	/**
	 * 
	 */
	public static function init()
	{
		self::$enabled = TRUE;
	}

	/**
	 * λ
	 */
	public static function terminate()
	{
		self::$enabled = FALSE;
	}

	/**
	 * ǥХåͭ
	 */
	private static function isEnabled()
	{
		return self::$enabled && charcoal_Profile::getBoolean( 'LOG_ENABLED' );
	}

	/*
	 *	ɲ
	 */
	public static function append( $key, charcoal_ILogger $logger )
	{
		// ˥å
		self::$loggers[ "$key" ] = $logger;
	}

	/*
	 *	Խ
	 */
	public static function writeln( $target, $message, $file, $line )
	{
		if ( !self::isEnabled() ){
			return;
		}
		
		// ٥ȥ̾
		list( $level, $logger_names ) = self::_getLevelAndTargetList( $target );

		self::_writelnAll( $level, $logger_names, $message, $file, $line );
	}
	
	/*
	 *	
	 */
	public static function writeArray( $target, $ary, $file, $line )
	{
		if ( !self::isEnabled() ){
			return;
		}

		// ٥ȥ̾
		list( $level, $logger_names ) = self::_getLevelAndTargetList( $target );

		foreach( $ary as $key => $value ){
			$message = "[$key]=>$value";
			self::_writelnAll( $level, $logger_names, $message, $file, $line );
		}
	}

	/*
	 *	ϿƤ٤Ƥ˥
	 */
	private static function _writelnAll( $level, $logger_names, $message, $file, $line )
	{
		// ٥
		$profile_level = charcoal_Profile::getString( 'LOG_LEVEL' );

		if ( !$profile_level ){
			// LOG_LEVELꤵƤʤϡWARNINGʾ
			$profile_level = self::LOGLEVEL_WARNING;
		}

		if ( is_string($profile_level) ){
			switch( $profile_level ){
			case 'F':	$profile_level = self::LOGLEVEL_FATAL;		break;		// FATAL
			case 'E':	$profile_level = self::LOGLEVEL_ERROR;		break;		// ERROR
			case 'W':	$profile_level = self::LOGLEVEL_WARNING;	break;		// WARNING
			case 'I':	$profile_level = self::LOGLEVEL_INFO;		break;		// INFO
			case 'D':	$profile_level = self::LOGLEVEL_DEBUG;		break;		// DEBUG
			case 'T':	$profile_level = self::LOGLEVEL_TRACE;		break;		// TRACE
			default:	$profile_level = self::LOGLEVEL_INFO;		break;		// as INFO
			}
		}

		// ٥뤬Ǥʤ㳰
		if ( !is_integer($profile_level) ){
			throw new charcoal_IllegalLogLevelException( s($profile_level), $file, $line );
		}


		// оݥФƤΤ߽
		foreach( $logger_names as $key ){
			$logger = self::$loggers[ $key ];
			if ( $logger !== NULL ){
				$logger->writeln( $key, $level, $message, $file, $line );
			}
//			else{
//				throw new charcoal_IllegalLogTargetException( s($key), $file, $line );
//			}
		}
	}

	/*
	 *	target٥ȥ̾
	 *
	 *	targetʸΥեޥåȡ
	 *
	 *  [٥]:[̾],[̾],...
	 *	ex) "I:app,debug,sql"
	 */
	private static function _getLevelAndTargetList( $target )
	{
		// ʬ
		list($level,$logger_names) = explode( ":" , "$target" );

		// ٥θ
		if ( is_string($level) ){
			switch( $level ){
			case 'F':	$level = self::LOGLEVEL_FATAL;		break;		// FATAL
			case 'E':	$level = self::LOGLEVEL_ERROR;		break;		// ERROR
			case 'W':	$level = self::LOGLEVEL_WARNING;	break;		// WARNING
			case 'I':	$level = self::LOGLEVEL_INFO;		break;		// INFO
			case 'D':	$level = self::LOGLEVEL_DEBUG;		break;		// DEBUG
			case 'T':	$level = self::LOGLEVEL_TRACE;		break;		// TRACE
			default:	$level = self::LOGLEVEL_INFO;		break;		// as INFO
			}
		}

		// ٥뤬Ǥʤ㳰
		if ( !is_integer($level) ){
			throw new charcoal_IllegalLogLevelException( $target, $file, $line );
		}

		// ̾ꥹ
		$logger_names = explode( "," , $logger_names );

		return array( $level, $logger_names );
	}

}
