<?php
/**
*  ե졼Υᥤ󥯥饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_Framework
{
	/*
	 *	ե졼ư
	 */
	public static function run()
	{
		try{
			//=======================================
			// ν
			//

			// ץեꤵƤ
			$logger_names = charcoal_Profile::getArray( 'LOG_LOGGERS' );

			// Ͽ
			foreach( $logger_names as $key ){
				$logger = charcoal_LoggerFactory::create( $key );
				charcoal_Logger::append( $key, $logger );
			}

			// Ϥ򳫻
			charcoal_Logger::init();

			// ưå
			log_info( 'system,config', '===========================================================', __FILE__, __LINE__ );
			log_info( 'system,config', ' CHARCOAL framework version 1.0 (c)sazysoft,stk2k          ', __FILE__, __LINE__ );
			log_info( 'system,config', '===========================================================', __FILE__, __LINE__ );

			log_info( 'system', 'charcoalե졼򳫻Ϥޤ', __FILE__, __LINE__ );


			//=======================================
			// Requestѥ᡼μ
			//

			log_info( 'system', 'Requestѥ᡼βϤ򳫻Ϥޤ', __FILE__, __LINE__ );

			// Request֥Ȥ
			$request = new charcoal_Request();
			$request->load();

			log_info( 'system', 'ץ㥭[$proc]Ǥ', __FILE__, __LINE__ );

			//=======================================
			// ꥯȥǥѥå
			//

			log_info( 'system', 'Dispatch򳫻Ϥޤ', __FILE__, __LINE__ );

			// ǥѥå̾ե뤫
			$dispacher_name = charcoal_Profile::getString( 'DISPATCHER' );

			// ǥѥå
			$dispatcher = charcoal_DispatcherFactory::create( $dispacher_name );

			// ǥѥå
			$proc = $dispatcher->dispatch( $request );

			log_info( 'system', 'Dispatchλޤǥѥå=[$proc]', __FILE__, __LINE__ );

			//=======================================
			// Procedureκ
			//

			log_info( 'system', 'ץ[$proc]ޤ', __FILE__, __LINE__ );

			// ץ
			$procedure = charcoal_ProcedureFactory::create( $proc );

			log_info( 'system', 'ץ[$proc]ޤ', __FILE__, __LINE__ );

			//=======================================
			// ƥʤκȵư
			//

			log_info( 'system', 'DIƥʤκ򳫻Ϥޤ', __FILE__, __LINE__ );

			// DIƥʤ
			charcoal_DIContainer::createContainer( $procedure );

			//=======================================
			// Responseκ
			//

			log_info( 'system', 'Response֥Ȥޤ', __FILE__, __LINE__ );

			// Request֥Ȥ
			$response = new charcoal_Response();

			//=======================================
			// ProcedureContextκ
			//

			log_info( 'system', 'ProcedureContext֥Ȥޤ', __FILE__, __LINE__ );

			// ProcedureContext֥Ȥ
			$context = new charcoal_ProcedureContext( $proc );

			//=======================================
			// Procedureμ¹
			//

			log_info( 'system', 'ץ[$proc]¹Ԥޤ', __FILE__, __LINE__ );

			// ץμ¹
			$procedure->execute( $request, $context, $response );

			log_info( 'system', 'ץ[$proc]¹Ԥޤ', __FILE__, __LINE__ );

			//=======================================
			// ƥʤ˴
			//

			log_info( 'system', 'DIƥʤ˴ޤ', __FILE__, __LINE__ );

			charcoal_DIContainer::destroy();

			//=======================================
			// λ
			//

			// ưå
			log_info( 'system', 'charcoalե졼λޤ', __FILE__, __LINE__ );
		}
		catch ( charcoal_HttpException $e )
		{
			// ץե뤫饹ơɤбɥȤ
			$error_doc = charcoal_Profile::getString( 'ERROR_DOC_' . $e->getStatusCode() );

			// 桼error_docs򸡺
			$html_file = charcoal_ResourceLocator::getPath( charcoal_ResourcePath::WEBAPP, '/error_docs/' . $error_doc );

			if ( !is_file($html_file) ){
				// ʤХǥեȤerror_docs򸡺
				$html_file = CHARCOAL_HOME . '/error_docs/' . $error_doc;
			}

			if ( is_file($html_file) ){
				// ɤ߹ߤɽ
				readfile( $html_file );
			}

			// إå
			switch ( $e->getStatusCode() ){
			case 401:
				header('HTTP/1.0 401 Unauthorized');
				break;
			case 403:
				header('HTTP/1.0 403 Forbidden');
				break;
			case 404:
				header("HTTP/1.0 404 Not Found");
				break;
			case 500:
				header('HTTP/1.0 500 Internal Server Error');
				break;
			}
		}
		catch ( charcoal_Exception $e ){

			$cause_list = $e->getCauseList();

			$cause_list[] = new charcoal_Exception( 'Framework#run() failed', $e );

			include( 'core/exception_list.php' );

		}
	}
}
