<?php
/**
* DIƥʥ饹
*
* ܺ
* ƥʤεǽ륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class charcoal_DIContainer 
{
	var $_components;
	var $_component_configs;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_components = array();
		$this->_component_configs = array();
	}

	/*
	 *    ͣΥ󥹥󥹼
	 */
	private static function &getInstance()
	{
		static $singleton_;
		if ( $singleton_ == null ){
			$singleton_ = new charcoal_DIContainer();
		}
		return $singleton_;
	}

	/**
	 * DIƥʤ
	**/
	public static function createContainer( charcoal_IProcedure $procedure )
	{
		log_info( "system",  "DIƥʤν򳫻Ϥޤ", __FILE__, __LINE__ );

		// 󥹥󥹤μ
		$container = & charcoal_DIContainer::getInstance();

		// ==================================================
		// ݡͥեɤ߹
		// ==================================================

		// ݡͥեΥѥ
		$component_config_file = charcoal_ResourceLocator::getPath( charcoal_ResourcePath::CONFIG, 'component_defs.ini' );

		// sectionդiniեѡ
		$container->component_config_files = parse_ini_file($component_config_file,TRUE);

		log_info( "system",  "DIƥʤνλޤ", __FILE__, __LINE__ );

	}

	/*
	 * DIƥʤ˴
	 */
	public static function destroy()
	{
		log_info( "system",  "DIƥʤ˴򳫻Ϥޤ", __FILE__, __LINE__ );

		// 󥹥󥹤μ
		$container = & charcoal_DIContainer::getInstance();

		// ݡͥȤ˴
		$container->destroyComponents();

		log_info( "system",  "DIƥʤ˴λޤ", __FILE__, __LINE__ );
	}

	/*
	 * ݡͥȤ
	 */
	public function loadComponent( $component_name )
	{
		log_info( "system",  "ݡͥ[$component_name]ɤޤ", __FILE__, __LINE__ );

		// ݡͥեɤ߹
		$config = charcoal_ConfigLoader::loadConfig( $component_name, "component" );

		// å¸
		$this->_component_configs[ "$component_name" ] = $config;

		// 饹̾
		$class_name = $config->getString( "class_name" );

		// ݡͥȥפ
		$scope = $config->getString( 'scope' );

		// ݡͥȥפˤäˡѹ
		switch ( $scope ){
		case charcoal_ComponentScope::TRANSIENT:
		case charcoal_ComponentScope::REQUEST:
			{
				// ݡͥȤΥ󥹥
				$component = charcoal_ClassUtil::newInstance( $class_name );
			}
			break;

		case charcoal_ComponentScope::SESSION:
			{
				// ݡͥȤΥ󥹥󥹤򥻥å󤫤
				$component = unserialize( $_SESSION[ $component_name ] );

				// åˤʤС󥹥󥹤
				if ( $component == NULL ){
					$component = charcoal_ClassUtil::newInstance( $class_name );
				}

			}
			break;
		}


		if ( !$component ){
			// scope˻ꤵ줿ɤ
			throw new charcoal_ComponentConfigException( $component_name, "scope", "invalid key word:$scope" );
		}

		// 󥹥󥹤IComponent󥿥եƤ뤫ǧ
		if ( !($component instanceof charcoal_IComponent) ){
			// 㳰
			throw new charcoal_InterfaceImplementException( $class_name, "charcoal_IComponent" );
		}

		log_info( "system",  "ݡͥ[$component_name]ޤ", __FILE__, __LINE__ );

		// ݡͥȤ
		$component->init( $config );

		// ݡͥȤϿ
		$this->_components[ "$component_name" ] = $component;

		log_info( "system",  "ݡͥ[$component_name]ɤޤ", __FILE__, __LINE__ );

		// ɤݡͥȤֵ
		return $component;
	}

	/*
	 * ϿѤߥݡͥȤ
	 */
	public static function getComponent( $key )
	{
		// 󥹥󥹤μ
		$container = & charcoal_DIContainer::getInstance();

		// ݡͥȤμ
		$component = $container->_components[ $key ];

		// ϿƤʤХɤߤ
		if ( $component == NULL ){

			$component = $container->loadComponent( $key );

			if ( $component == NULL ){
				throw new charcoal_ComponentNotRegisteredException( $key );
			}
		}

		// ݡͥ
		$component_config = $container->_component_configs[ $key ];

		// ϿƤʤ㳰
		if ( $component_config == NULL ){
			throw new charcoal_ComponentNotRegisteredException( $key );
		}

		// ݡͥȥפ
		$scope = $component_config->getString( 'scope' );

		// ϿƤʤ㳰
		if ( $scope == NULL ){
			throw new charcoal_ComponentConfigException( $key, "scope", "mandatory" );
		}

		// ݡͥȤֵ
		switch ( $scope ){
		case charcoal_ComponentScope::TRANSIENT:
			return clone $component;

		case charcoal_ComponentScope::REQUEST:
			return $component;

		case charcoal_ComponentScope::SESSION:
			return $component;
		}

		// scope˻ꤵ줿ɤ
		throw new charcoal_ComponentConfigException( $key, "scope", "invalid key word:$scope" );

		return NULL;
	}

	/*
	 * ϿѤߥݡͥȤ˴sessionץݡͥȤϥåƤ¸
	 */
	public function destroyComponents()
	{
		log_info( "system",  "DIƥΥݡͥȤ˴ޤ", __FILE__, __LINE__ );

		
		// 󥹥󥹤μ
		$container = & charcoal_DIContainer::getInstance();

		// ݡͥȤμ
		$components = $container->_components;

		// ٤ƤΥݡͥȤ˴
		foreach( $components as $component_name => $component ){

			// ݡͥ
			$component_config = $container->_component_configs[ $component_name ];

			// ݡͥȥפ
			$scope = $component_config->getString( 'scope' );

			// ݡͥȥפˤäƽʬ
			switch ( $scope ){
			case charcoal_ComponentScope::TRANSIENT:
			case charcoal_ComponentScope::REQUEST:
				// ʤˤ⤷ʤ
				break;

			case charcoal_ComponentScope::SESSION:
				{
					// å˥󥹥󥹤򥻥å
					$_SESSION[ $component_name ] = serialize( $component );

					log_info( "system",  "ݡͥ[$component_name]ϥå¸ޤ", __FILE__, __LINE__ );
				}
				break;
			}

		}

		log_info( "system",  "DIƥΥݡͥȤ˴ޤ", __FILE__, __LINE__ );

	}

	/*
	 * 
	 */
	public function dump(){
		return $this->_components[ $key ];
	}
}
