<?php
/**
* ᡼ݡͥ
*
* PHP version 5
*
* @package    components.mail
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

require_once( 'Mail.php' );
require_once( 'Mail/mime.php' );

require_once( 'CharcoalMailException.class.php' );

class CharcoalMail implements IComponent
{
	var $_backend;
	var $_host;
	var $_port;
	var $_auth;
	var $_username;
	var $_password;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
	}

	/*
	 * ݡͥ̾
	 */
	public function getComponentName(){
		return "CharcoalMail Component";
	}

	/*
	 * ݡͥȤ
	 */
	public function initComponent( $component_config ){

		$this->_backend   = $component_config->getString("backend");
		$this->_host      = $component_config->getString("host");
		$this->_port      = $component_config->getString("port");
		$this->_auth      = $component_config->getString("auth");
		$this->_username  = $component_config->getString("username");
		$this->_password  = $component_config->getString("password");

	}

	/*
	 * ƥȥ᡼
	 */
	public function sendMail( $from, $to, $subject, $body, $cc = NULL, $bcc = NULL){

		Logger::writeln( LogLevel::DEBUG,  "[START] CharcoalMail#sendMail($from, $to, $subject, $body, $cc, $bcc)", __FILE__, __LINE__ );

		$ec = new EncodingConverter( EncodingConverter::PHP_TO_MAIL );

		$address = array();

		// ɥ쥹
		if ( $from ){
			$header['From'] = $from;
			$header['Reply-To'] = $from;
		}
		if ( $to ){
			$header['To'] = $to;
			array_push( $address, $to );
		}
		if ( $cc ){
			$header['Cc'] = $cc;
			array_push( $address, $cc );
		}
		if ( $bcc ){
			$header['Bcc'] = $bcc;
			array_push( $address, $bcc );
		}

		// ̾MIMEѴ
		$subject = $ec->convertEncoding( $subject );
		$orgEncoding = mb_internal_encoding();
		mb_internal_encoding( "ISO-2022-JP" );
		$subject = mb_encode_mimeheader($subject, "ISO-2022-JP", 'B', "\n");
		mb_internal_encoding($orgEncoding); 

		$header['Subject'] = $subject;

		// ʸISO-2022-JPѴ
		$body = $ec->convertEncoding( $body );

		$param['host'] = $this->_host;
		$param['port'] = $this->_port;
		$param['auth'] = $this->_auth;
		$param['username'] = $this->_username;
		$param['password'] = $this->_password;

		// ᡼֥
		$mail = Mail::factory($this->_backend, $param);

		// 
		$ret = $mail->send($address, $header, $body);

		// 顼Ƚ
		if ( PEAR::isError($ret) ) {
			throw new CharcoalMailException( $ret->getMessage() );
		}

		Logger::writeln( LogLevel::DEBUG,  "[END] CharcoalMail#sendMail($from, $to, $subject, $body, $cc, $bcc)", __FILE__, __LINE__ );
	}

	/*
	 * HTML᡼
	 */
	public function sendHtmlMail( $from, $to, $subject, $html_body, $text_body, $cc = NULL, $bcc = NULL){

		$ec = new EncodingConverter( EncodingConverter::PHP_TO_MAIL );

		$address = array();

		// ɥ쥹
		if ( $from ){
			$header['From'] = $from;
			$header['Reply-To'] = $from;
		}
		if ( $to ){
			$header['To'] = $to;
			array_push( $address, $to );
		}
		if ( $cc ){
			$header['Cc'] = $cc;
			array_push( $address, $cc );
		}
		if ( $bcc ){
			$header['Bcc'] = $bcc;
			array_push( $address, $bcc );
		}

		// ̾MIMEѴ
		$subject = $ec->convertEncoding( $subject );
		$orgEncoding = mb_internal_encoding();
		mb_internal_encoding( "ISO-2022-JP" );
		$subject = mb_encode_mimeheader($subject, "ISO-2022-JP", 'B', "\n");
		mb_internal_encoding($orgEncoding); 

		$header['Subject'] = $subject;

		// ʸISO-2022-JPѴ
		$text_body = $ec->convertEncoding( $text_body );

		$param['host'] = $this->_host;
		$param['port'] = $this->_port;
		$param['auth'] = $this->_auth;
		$param['username'] = $this->_username;
		$param['password'] = $this->_password;

		$param['html_charset'] = "EUC-JP";
		$param['text_charset'] = "ISO-2022-JP";
		$param['head_charset'] = "ISO-2022-JP";

		// ᡼֥
		$mail = Mail::factory($this->_backend, $param);

		// MIME֥
		$mime = new Mail_mime("\n");

		$mime->setTXTBody( $text_body ); 
		$mime->setHTMLBody( $html_body );

		// ѥѥ᡼
		$build_param = array(
			"html_charset" => "EUC-JP",
			"text_charset" => "ISO-2022-JP",
			"head_charset" => "ISO-2022-JP",
		);

		$body = $mime->get( $build_param );
		$header = $mime->headers($header);

		// 
		$ret = $mail->send($address, $header, $body);

		// 顼Ƚ
		if ( PEAR::isError($ret) ) {
			throw new CharcoalMailException( $ret->getMessage() );
		}
	}


}

?>
