<?php
/**
* ǡݡͥ
*
* PHP version 5
*
* @package    components.db
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once( 'DB.php' );

require_once( 'exceptions/DataAccessException.class.php' );
require_once( 'exceptions/PearDBException.class.php' );
require_once( 'exceptions/PrepareSQLException.class.php' );

class charcoal_db_DataSource implements charcoal_IComponent
{

	var $_connected = false;
	var $_connection;

	var $_dbuser;
	var $_dbpass;
	var $_dbname;
	var $_server;

	var $_charset;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_connected 	= false;
		$this->_connection 	= null;
	}

	/*
	 * ݡͥ̾
	 */
	public function getComponentName()
	{
		return "DataSource Component";
	}

	/*
	 * ݡͥȤ
	 */
	public function init( charcoal_Config $config )
	{
		$this->_dbuser   = $config->getString( 'DB_USER' );
		$this->_dbpass   = $config->getString( 'DB_PASS' );
		$this->_dbname   = $config->getString( 'DB_NAME' );
		$this->_server   = $config->getString( 'DB_HOST' );
		$this->_charset  = $config->getString( 'DB_CHARSET' );
	}

	/*
	 *    ³Ѥߤ
	 */
	public function isConnected()
	{
		return $this->_connected;
	}

	/*
	 *    ߥåȤȯ
	 */
	public function commit()
	{
		try {
		
			$this->_connection->commit();
			
		} catch (PDOException $e) {
			throw new DataAccessException( $e->getMessage() );
		}
	}

	/*
	 *    ³
	 */
	public function connect( $dbuser, $dbpass, $server, $dbname )
	{
		// ³Ѥߤʤ鲿⤷ʤ
		if ( $this->_connected ){
			return;
		}

		$dbstring = "mysql://$dbuser:$dbpass@$server/$dbname";
		log_info( "sql", "DB³Ԥޤ³ʸ=[$dbstring]", __FILE__, __LINE__ );

		$db = DB::connect( $dbstring );
		
		if ( DB::isError($db) ){
			$msg = DB::errorMessage($db) . "/" . $dbstring;
			log_error( 'system', $msg, __FILE__, __LINE__ );
			throw new PearDBException( $db );
		}
	
		log_info( "sql", "DB³ޤ", __FILE__, __LINE__ );

		$this->_connection = $db;
		$this->_connected = true;

		// ʸк
		$charset = $this->_charset;
		$db->query( "SET NAMES $charset" );
	}

	/*
	 *    ץڥɥơȥȤȯ
	 */
	private function _prepareExecute( $sql, $params = NULL )
	{
//print "SQL:$sql start<BR>";
		$conv = new charcoal_EncodingConverter( charcoal_EncodingConverter::DB_TO_LOG );
		log_info( "sql", $sql, __FILE__, __LINE__ );
		if ( $params ){
			charcoal_Logger::writeArray( "i:sql", $params, __FILE__, __LINE__ );
		}

//print "SQL:$sql<BR>";

		for( $i=0; $i<count($params); $i++ ){
			$p1 = $params[$i];
			if ( is_string($p1) ){
				$params[$i] = $p1;
			}
		}

		$stmt = $this->_connection->prepare($sql);
	
		if ( DB::isError($stmt) ){
			$msg = $stmt->getMessage();
			log_error( "system", $msg ,__FILE__,__LINE__ );
			throw new PearDBException( $msg, $sql, $params );
		}

		$result = $this->_connection->execute($stmt, $params);
		
		if ( DB::isError($result) ){
			$msg = $result->getMessage();
			log_error( "system", $msg ,__FILE__,__LINE__ );
			throw new PearDBException( $result );
		}

		return $result;
	}

	/*
	 *    SQL򤽤Τޤȯ
	 */
	private function _query( $sql, $file, $line  )
	{
		log_info( "sql", $sql, $file, $line  );
	
		$result = $this->_connection->query($sql);
			
		if ( DB::isError($result) ){
			throw new DataAccessException( $sql, NULL, $result->getMessage() );
		}

		return $result;
	}

	/*
	 *    SQL򤽤Τޤȯԡʷ̥åȤ
	 */
	public function query( $sql, $file, $line  )
	{
		// ³
		$this->connect( $this->_dbuser, $this->_dbpass, $this->_server, $this->_dbname );

		// SQL¹ԤƷ̥åȤ
		$resultset = $this->_query( $sql, $file, $line  );

		// ̥åȤֵ
		return $resultset;
	}

	/*
	 *    SQL򤽤Τޤȯԡʷ̥åȤʤ
	 */
	public function execute( $sql, $file, $line  )
	{
		// ³
		$this->connect( $this->_dbuser, $this->_dbpass, $this->_server, $this->_dbname );

		// SQL¹
		$this->_query( $sql, $file, $line  );
	}

	/*
	 *    ץڥɥơȥȤȯ
	 */
	public function prepareExecute( $sql, $params = NULL )
	{
		$result = null;
		
		try {
			// ³
			$this->connect( $this->_dbuser, $this->_dbpass, $this->_server, $this->_dbname );

			// statementμ¹
			if ( $params ){
				$result = $this->_prepareExecute( $sql, $params );
			}
			else{
				$result = $this->_prepareExecute( $sql );
			}
		}
		catch ( Exception $e ) {
			throw new PrepareSQLException( $sql, $params, 'DataSource#prepareExecute() failed', $e );
		}

		return $result;
	}

	/*
	 *    ¹Է̷
	 */
	function numRows( $result )
	{
		return $result->numRows();
	}

	/*
	 *    եåϢֵѡ
	 */
	public function fetchAssoc( $result )
	{
		if ( $result === NULL ){
			throw new charcoal_NullPointerException();
		}
		if ( !is_object($result) ){
			throw new charcoal_NonObjectException( $result );
		}
		return $result->fetchRow(DB_FETCHMODE_ASSOC);
	}

	/*
	 *    եåֵѡ
	 */
	public function fetchArray( $result )
	{
		if ( $result === NULL ){
			throw new charcoal_NullPointerException();
		}
		if ( !is_object($result) ){
			throw new charcoal_NonObjectException( $result );
		}
		return $result->fetchRow(DB_FETCHMODE_ORDERED);
	}

	/*
	 *   Ǹ˼¹Ԥ줿AUTO_INCREMENTͤ
	 */
	public function getLastInsertId()
	{
		$sql  = 'select LAST_INSERT_ID()';

		$result = $this->prepareExecute( $sql, NULL, __FILE__, __LINE__ );

		if ( $row = $this->fetchArray($result) ){
			$val = $row[0];
			return $val;
		}

		return -1;
	}

	/*
	 *   Υեɺͤ
	 */
	public function getMaxValue( $field, $table )
	{
		$sql  = "select max($field) from $table";

		$params = array( );
		$result = $this->prepareExecute( $sql, $params, __FILE__, __LINE__ );

		if ( $row = $this->fetchArray($result) ){
			$val = $row[0];
			return is_int($val) ? (int)$val : 0;
		}

		return 0;
	}
}
