<?php

/**
* ǡȥݡͥ
*
* PHP version 5
*
* @package    components.db
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once( 'Criteria.class.php');
require_once( 'KeyField.class.php');
require_once( 'UpdateByValue.class.php');
require_once( 'UpdateByFunction.class.php');

require_once( 'exceptions/DataGatewayException.class.php');
require_once( 'exceptions/TableNameMappingException.class.php');

class charcoal_db_DataGateway implements charcoal_IComponent
{
	var $_tablename_map;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_tablename_map = array();
	}


	/*
	 * ݡͥ̾
	 */
	public function getComponentName()
	{
		return "DataGateway Component";
	}

	/*
	 * ݡͥȤ
	 */
	public function init( charcoal_Config $config )
	{
		// DTO_TABLENAME_MAPPINGɤ߹
		$this->_tablename_map = $config->getArray( 'dto_table_mapping' );
	}

	/*
	 * ԥǡ饪֥
	 */
	private  function rowToObject( $row, $dto_object, charcoal_EncodingConverter $conv = NULL  )
	{
		if ( !$dto_object ){
			return NULL;
		}

		$o = clone $dto_object;

		$class_vars = get_class_vars(get_class($dto_object));

		foreach ($class_vars as $name => $value) 
		{
			// ե
			$value = $row[ $name ];
			// ʸʤ饨󥳡ǥѴ
			if ( $conv && is_string($value) ){
				$value = $conv->convertEncoding($value);
			}
			// DTOΥץѥƥ˥å
			$o->$name = $value;
		}

		return $o;
	}

	/*
	 *	SQL(SELECT)
	 */
	private  function buildSelectSQL( $table, charcoal_db_Criteria $condition = NULL )
	{
		$sql = "select * from $table";

		if ( !$condition ){
			return $sql;
		}

		$where_clause = $condition->getWhereClause();
		$order_by     = $condition->getOrderBy();
		$limit        = $condition->getLimit();
		$offset       = $condition->getOffset();

		if ( $where_clause != NULL ){
			$sql .= " where $where_clause";
		}
		if ( $order_by != NULL ){
			$sql .= " order by $order_by";
		}
		if ( $limit != NULL ){
			$sql .= " limit $limit";
		}
		if ( $offset != NULL ){
			$sql .= " offset $offset";
		}
	
		return $sql;
	}

	/*
	 *	SQL(UPDATE)
	 */
	private  function buildUpdateSQL( $table, $dto_object )
	{
		$object_vars = get_object_vars($dto_object);

		$params      = array();
		$set         = NULL;
		$key_fields  = array();

		foreach ($object_vars as $name => $value) 
		{
			// ˡˤäʬ
			if ( $value instanceof charcoal_db_KeyField ){
				// եɤʤΤǹʤ
				$key_fields[ $name ] = $value->getKeyValue();
				continue;
			}
			else if ( $value instanceof charcoal_db_UpdateByValue ){
				// ͤǹ
				// 
				if ( $set != NULL ){
					$set .= ",";
				}
				// set X=Y
				$set .= "$name = ?";
				// ѥ᡼ɲ
				$params[] =  $value->getUpdateValue();
				continue;
			}
			else if ( $value instanceof charcoal_db_UpdateByFunction ){
				// ؿǹ
				// 
				if ( $set != NULL ){
					$set .= ",";
				}
				// set X=func
				$set .= $name . '=' . $value->getUpdateFunction();
				continue;
			}
		}

		// WHERE
		$where = NULL;
		foreach( $key_fields as $name => $value )
		{
			// ANDɲ
			if ( $where != NULL ){
				$where .= ' and ';
			}
			// ơȥȤɲ
			$where .= "$name = ?";
			// ѥ᡼ɲ
			$params[] = $value;
		}

		$sql = "update $table set $set where $where";

		return array( $sql, $params );
	}

	/*
	 *	SQL(INSERT)
	 */
	private  function buildInsertSQL( $table, $dto_object )
	{
		$object_vars = get_object_vars($dto_object);

		$field_list   = NULL;
		$value_list   = NULL;
		$params       = array();
		$key_fields   = array();

		foreach ($object_vars as $name => $value) 
		{
			if ( $value instanceof charcoal_db_UpdateByValue ){
				// ͤǹ
				$field_list[] = $name;
				$value_list[] = '?';
				// ѥ᡼ɲ
				$params[] = $value->getUpdateValue();
				continue;
			}
			else if ( $value instanceof charcoal_db_UpdateByFunction ){
				// ؿǹ
				$field_list[] = $name;
				$value_list[] = $value->getUpdateFunction();
				continue;
			}
		}

		$field_list = implode( ',', $field_list );
		$value_list = implode( ',', $value_list );

		$sql = "insert into $table($field_list) values($value_list)";

		return array( $sql, $params );
	}

	/*
	 *	¸
	 */
	public  function save( $dto_object, $auto_reload = FALSE )
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto_object );

			// եɤꤵƤUPDATEꤵƤʤINSERTȽ
			$object_vars = get_object_vars($dto_object);

			$is_new = TRUE;
			foreach ($object_vars as $name => $value) {
				if ( $value instanceof charcoal_db_KeyField ){
					$is_new = FALSE;
					break;
				}
			}

			// SQL
			if ( $is_new ){
				list( $sql, $params ) = $this->buildInsertSQL( $table, $dto_object );
			}
			else{
				list( $sql, $params ) = $this->buildUpdateSQL( $table, $dto_object );
			}

			// SQL¹
			$this->execute( $sql, $params );

			// ޤɲä֥Ȥ
			if ( !$auto_reload ){
				// ưɤʤϤޤ
				return NULL;
			}

			if ( $is_new ){

				// ƥʤDataSourceݡͥȤ
				$data_source = charcoal_DIContainer::getComponent( 'db:DataSource' );

				$id = $data_source->getLastInsertId();
			}
			else{
				$id = $dto_object->id;
			}
			
			return $this->findByID($dto_object, $id);
		}
		catch ( Exception $e ){
			throw new DataGatewayException( "DataGateway#save failed", $e );
		}
	}

	/*
	 *	SQL¹(INSERT/DELETE/UPDATE)
	 */
	public  function execute( $sql, $params = NULL )
	{
		// ƥʤDataSourceݡͥȤ
		$data_source = charcoal_DIContainer::getComponent( 'db:DataSource' );

		try{

			// ¹
			$data_source->prepareExecute( $sql, $params, __FILE__, __LINE__ );

		}
		catch ( Exception $e ) {

			// ̤throw
			throw new DataGatewayException( "exec_SQL failed", $e );
		}
	}

	/*
	 *	SQL¹(SELECT)
	 */
	public  function query( $sql, $params = NULL )
	{
		// ƥʤDataSourceݡͥȤ
		$data_source = charcoal_DIContainer::getComponent( 'db:DataSource' );

		$a = array();

		try{

			// ¹
			$result = $data_source->prepareExecute( $sql, $params, __FILE__, __LINE__ );

			// եå
			while( $row = $data_source->fetchAssoc( $result ) ){
				$a[] = $row;
			}
		}
		catch ( Exception $e ) {

			// ̤throw
			throw new DataGatewayException( "exec_SQL failed", $e );
		}

		return $a;
	}

	/*
	 *	SQL
	 */
	public  function findBySQL( $dto_object, $sql, $params = NULL, charcoal_EncodingConverter $conv = NULL ) 
	{
		$a = array();

		// DataSourceݡͥȤ
		$data_source = charcoal_DIContainer::getComponent( 'db:DataSource' );

		// ƥʤResultSetLoggerݡͥȤ
		$row_logger = charcoal_DIContainer::getComponent( 'db:ResultSetLogger' );

		// ϳ
		$row_logger->start();

		try{

			// ¹
			if ( $params ){
				$result = $data_source->prepareExecute( $sql, $params );
			}
			else{
				$result = $data_source->prepareExecute( $sql );
			}

			// եå
			while( $row = $data_source->fetchAssoc( $result ) ){
				$o = $this->rowToObject( $row, $dto_object, $conv );
				$row_logger->logRowInfoAssoc( $row );
				if ( $o ){
					array_push( $a, $o );
				}
			}
		}
		catch ( Exception $e ) {

			// ̤throw
			throw new DataAccessException( $sql, $params, "findBySQL failed", $e );
		}

		return $a;
	}

	/*
	 *	ǽΣ
	 */
	public  function findFirst( $dto_object, charcoal_db_Criteria $condition = NULL, charcoal_EncodingConverter $conv = NULL ) 
	{
		if ( !$condition ){
			$condition = new charcoal_db_Criteria();
		}

		// LIMIT=1
		$condition->setLimit( 1 );

		// ¹
		$result = $this->findAll( $dto_object, $condition, $conv );

		return array_shift($result);
	}

	/*
	 *	
	 */
	public  function findAll( $dto_object, charcoal_db_Criteria $condition = NULL, charcoal_EncodingConverter $conv = NULL ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto_object );


			// SQLκ
			if ( $condition ){
				$sql = $this->buildSelectSQL( $table, $condition );
			}
			else{
				$sql = $this->buildSelectSQL( $table );
			}

			// ѥ᡼
			$params = $condition ? $condition->getParams() : NULL;

			// ¹
			$result = $this->findBySQL( $dto_object, $sql, $params, $conv );

			return $result;
		}
		catch ( Exception $e ){
			throw new DataGatewayException( "DataGateway#findAll failed", $e );
		}
	}

	/*
	 *	ĤΥեɤΤߤǸ
	 */
	public  function findAllBy( $dto_object, $field, $value, charcoal_db_Criteria $condition = NULL, charcoal_EncodingConverter $conv = NULL )
	{
		if ( !$condition ){
			$condition = new charcoal_db_Criteria();
		}

		$condition->setWhereClause( "$field = ?" );
		$condition->setParams( array( $value ) );

		$a = $this->findAll( $dto_object, $condition, $conv );

		return $a;
	}

	/*
	 *	ID鸡(Ĥꤷ)
	 */
	public  function findByID( $dto_object, $id, charcoal_EncodingConverter $conv = NULL ) 
	{
		// Ĥꤷ
		$where_clause = 'id = ?';
		$params = array( $id );

		$condition = new charcoal_db_Criteria( $where_clause, $params );

		$a = $this->findAll( $dto_object, $condition, $conv );

		return array_shift($a);
	}

	/*
	 *	ID鸡
	 */
	public  function findAllByID( $dto_object, $id_array ) 
	{
		// ʣĻꤷ
		$where = array();
		$params = array();
		
		foreach( $id_array as $id ){
			$where[] = "?";
			$params[] = $id;
		}

		$where_clause = "id in (" . implode(",",$where) . ")";

		$condition = new charcoal_db_Criteria( $where_clause, $params );

		$a = $this->findAll( $dto_object, $condition );

		return $a;
	}

	/*
	 *	ʣĤꤷ
	 */
	public  function destroyById( $dto_object, $id ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto_object );

			// Ĥꤷ
			$sql = "delete from $table where id = ?";
			$params = array( "$id" );

			$this->execute( $sql, $params );
		}
		catch ( Exception $e ){
			throw new DataGatewayException( "DataGateway#destroyById failed", $e );
		}
	}

	/*
	 *	ʣꤷ
	 */
	public  function destroyAllById( $dto_object, $id_array ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto_object );

			// ʣĻꤷ
			$where = array();
			$params = array();
			
			foreach( $id_array as $id ){
				$where[] = "?";
				$params[] = $id;
			}

			$sql = "delete from $table where id in (" . implode(",",$where) . ")";

			$this->execute( s($sql), a($params) );
		}
		catch ( Exception $e ){
			throw new DataGatewayException( "DataGateway#destroyById failed", $e );
		}
	}
	/*
	 *	ĤΥեɤ˹פ쥳ɤ
	 */
	public  function destroyBy( $dto_object, $field, $value )
	{
		$where_clause = "$field = ?";
		$params = array( $value );

		$this->destroyAll( $dto_object, $where_clause, $params );
	}


	/*
	 *	˹פ쥳ɤ
	 */
	public  function destroyAll( $dto_object, $where_clause = NULL, $params = NULL ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto_object );

			$sql = "delete from $table where $where_clause";

			$this->execute( $sql, $params );
		}
		catch ( Exception $e ){
			throw new DataGatewayException( "DataGateway#destroyAll failed", $e );
		}
	}

	/*
	 *	ơ֥Υ쥳ɿ
	 */
	public  function count( $dto_object, $where_clause = NULL, $params = NULL ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto_object );

			// SQL
			$sql = "select count(*) from $table";
			if ( $where_clause ){
				$sql .= " where $where_clause";
			}

			// SQL¹
			$rows = $this->query( $sql, $params );

			return $row[0][0];
		}
		catch ( Exception $e ){
			throw new DataGatewayException( "DataGateway#count failed", $e );
		}
	}

	/*
	 *	DTOơ֥̾
	 */
	public  function getTableNameFromDTO( $dto_object ) 
	{
		$dto_class = get_class($dto_object);
		$table = $this->_tablename_map[ $dto_class ];

		if ( $table == NULL ){
			throw new TableNameMappingException( $dto_class );
		}

		return $table;
	}

}
