<?
require_once( 'dto/ShouhinDTO.class.php' );

class TableCreateModule implements IModule
{
	/*
	 * ⥸塼̾
	 */
	public function getModuleName()
	{
		return "DB Connect module";
	}

	/*
	 * ⥸塼
	 */
	public function initModule( $module_config )
	{
	}

	/*
	 * ⥸塼ν¹Ԥ
	 */
	public function execute( Request $request, ModuleContext $context, Response $response )
	{
		// ƥʤDataSourceݡͥȤ
		$data_source = DIContainer::getComponent( "db:DataSource" );

		// ơ֥SQL
		$sql = <<< TABLE_CREATE_SQL
CREATE TABLE shouhin (
`id` BIGINT NOT NULL AUTO_INCREMENT ,
`item_code` VARCHAR( 255 ) CHARACTER SET utf8 NOT NULL ,
`item_name` VARCHAR( 255 ) CHARACTER SET utf8 NOT NULL ,
`price` INT NOT NULL ,
PRIMARY KEY ( `id` ) 
) 
TABLE_CREATE_SQL;

		// DB
		$data_source->execute( $sql, __FILE__, __LINE__ );

		// ǡ
		$data_list = array( 
				array( 'item_code' => 'ELH-001', 'item_name' => '鱩', 'price' => '54000' ),
				array( 'item_code' => 'THJ-2341', 'item_name' => 'ե٥å', 'price' => '43000' ),
				array( 'item_code' => 'BFD-1172D', 'item_name' => 'ѥǥ', 'price' => '22000' ),
			);

		// С
		$conv = new EncodingConverter( EncodingConverter::PHP_TO_DB );

		// DataGatewayݡͥȤ
		$gw = DIContainer::getComponent( "db:DataGateway" );

		// ǡ
		foreach( $data_list as $data )
		{
			// DTO
			$dto = new ShouhinDTO();

			// ǡ򥻥å
			$dto->item_code = $data['item_code'];
			$dto->item_name = $data['item_name'];
			$dto->price 	= $data['price'];

			// ʸѴ
			$dto->convertEncoding( $conv );

			// եɤ
			$update_fields = array(
					"id"			=> DataGateway::UPDATE_FIELD_NONE,
				);

			// DB¸
			$gw->save( $dto, TRUE, $update_fields, DataGateway::UPDATE_FIELD_VALUE );
		}

		return "success";
	}
}
?>