<?
/**
* Smarty
*
* PHP version 5
*
* @package    renderers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once( 'Smarty/Smarty.class.php' );

class SmartyRenderer implements IRenderer
{
	var $_config;
	var $_template_files;
	var $_smarty;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_template_files = array();
		$this->_smarty = new Smarty();
	}

	/*
	 * 顼̾
	 */
	public function getRendererName()
	{
		return "Smarty Renderer";
	}

	/*
	 * 顼
	 */
	public function initRenderer( $renderer_config )
	{
		$this->_config = $renderer_config;

		$this->_smarty->caching 		= $renderer_config->getConfig( 'caching' );
		$this->_smarty->compile_check 	= $renderer_config->getConfig( 'compile_check' );
		$this->_smarty->template_dir 	= $renderer_config->getConfig( 'template_dir' );
		$this->_smarty->compile_dir 	= $renderer_config->getConfig( 'compile_dir' );
		$this->_smarty->config_dir 		= $renderer_config->getConfig( 'config_dir' );
		$this->_smarty->cache_dir 		= $renderer_config->getConfig( 'cache_dir' );

		// ƥץ졼ȥեޥåԥ
		$this->_template_files	= $renderer_config->getConfig( 'template_files' );
	}

	/*
	 * ƥץ졼ȥե̾
	 */
	private function getTemplateFile( $template_name ){
		$template_file = $this->_template_files[ $template_name ];
		if ( !$template_file ){
$this->_config->dump();
			throw new TemplateFileNotFoundException( $template_name );
		}
		return $template_file;
	}

	/*
	 * 󥰤Ԥ
	 */
	public function render( $proc_key, ModuleContext $context, Response $response )
	{
		Logger::writeln( LogLevel::INFO,  "SmartyRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );

		try{

			// Smarty֥Ȥ
			$smarty = $this->_smarty;

			// ModuleContextȤ򤹤٤Smartyassign
			$keys = $context->getKeys();
			foreach( $keys as $key ){
				$value = $context->get( $key );
				$smarty->assign( $key, $value );
			}

			// ƥץ졼̾
			$template_name = $context->get( "smarty_template" );

			// ƥץ졼ȥե̾Ѵ
			$template_file = $this->getTemplateFile( $template_name );

			Logger::writeln( LogLevel::DEBUG,  "ƥץ졼̾$template_file", __FILE__, __LINE__ );

			// ƥץ졼ȤŸɽ
			$smarty->display( $template_file );
		}
		catch ( Exception $e ){
			throw new RendererException( $proc_key, "rendering failed", $e );
		}

		Logger::writeln( LogLevel::INFO,  "SmartyRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );
	}
}
?>