<?
/**
* PHPTAL
*
* PHP version 5
*
* @package    renderers
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once 'PHPTAL.php';

class PhpTalRenderer implements IRenderer
{
	var $_config;
	var $_template_files;
	var $_repository;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_config = NULL;
		$this->_template_files = array();
		$this->_repository = NULL;
	}

	/*
	 * 顼̾
	 */
	public function getRendererName()
	{
		return "Smarty Renderer";
	}

	/*
	 * 顼
	 */
	public function initRenderer( $renderer_config )
	{
		$this->_config = $renderer_config;

		// ƥץ졼ȥեޥåԥ
		$this->_template_files	= $renderer_config->getConfig( 'template_files' );

		// ݥȥ
		$this->_repository = $renderer_config->getConfig( 'repository' );
	}

	/*
	 * ƥץ졼ȥե̾
	 */
	private function getTemplateFile( $template_name ){
		$template_file = $this->_template_files[ $template_name ];
		if ( !$template_file ){
$this->_config->dump();
			throw new TemplateFileNotFoundException( $template_name );
		}
		return $template_file;
	}

	/*
	 * 󥰤Ԥ
	 */
	public function render( $proc_key, ModuleContext $context, Response $response )
	{
		Logger::writeln( LogLevel::INFO,  "PhpTalRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );

		try{

			// ƥץ졼̾
			$template_name = $context->get( "phptal_template" );

			// ƥץ졼ȥե̾Ѵ
			$template_file = $this->getTemplateFile( $template_name );

			// PHPTAL֥Ȥ
			$template = new PHPTAL( $template_file );

			// ModuleContextȤ򤹤٤assign
			$keys = $context->getKeys();
			foreach( $keys as $key ){
				$value = $context->get( $key );
				$template->$key = $value;
			}

			// ƥץ졼ȥѥ
			$template->setTemplateRepository( $this->_repository );

			// 
			echo $template->execute();

		}
		catch ( Exception $e ){
			throw new RendererException( $proc_key, "rendering failed", $e );
		}

		Logger::writeln( LogLevel::INFO,  "PhpTalRendererˤ󥰤Ԥޤ", __FILE__, __LINE__ );
	}
}
?>