<?
/**
* ⥸塼륰դץ
*
* PHP version 5
*
* @package    procedures
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once( 'core/ClassLoader.class.php' );

class ModuleGraphProcedure implements IProcedure
{
	var $_config;
	var $_output_filters;
	var $_classloaders;
	var $_renderer;
	var $_proc_name;

	/*
	 * ץ̾
	 */
	public function getProcedureName(){
		return "Module Graph Procedure";
	}

	/*
	 * ץ
	 */
	public function initProcedure( $procedure_name, $procedure_config ){

		$this->_proc_name 		= $procedure_name;
		$this->_config 			= $procedure_config;
		$this->_output_filters 	= $procedure_config->getConfig( "output_filters" );
		$this->_input_filters 	= $procedure_config->getConfig( "input_filters" );
		$this->_classloaders 	= $procedure_config->getConfig( "classloaders" );
		$this->_renderer 		= $procedure_config->getConfig( "renderer" );
	}

	/*
	 * ץ¹Ԥ
	 */
	public function execute( Request $request, ModuleContext $context, Response $response ){

		$proc_name = $this->_proc_name;
		Logger::writeln( LogLevel::INFO,  "ץ[$proc_name]¹Ԥޤ", __FILE__, __LINE__ );

		//=======================================
		// 饹Ͽ
		//
		if ( $this->_classloaders ){
			foreach( $this->_classloaders as $loader_name ){
				$loader = ClassLoaderFactory::createClassLoader( $loader_name );
				ClassLoader::addClassLoader( $loader );
			}
		}

		//=======================================
		// å
		//
		if ( Profile::getGlobalConfig("USE_SESSION") ){
			$context->getSession()->load();
		}

		//=======================================
		// ϥե륿μ¹
		//
		Logger::writeln( LogLevel::INFO,  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );

		if ( $this->_input_filters ){
			foreach( $this->_input_filters as $filter_name ){
				// ե륿
				$filter = FilterFactory::createFilter( $filter_name );
				// ե륿μ¹
				$filter->filter( $request, $context, $response );
			}
		}

		Logger::writeln( LogLevel::INFO,  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );

		//=======================================
		// ModuleGraphι
		//
		Logger::writeln( LogLevel::INFO,  "⥸塼륰դιۤԤޤ", __FILE__, __LINE__ );

		// եɤ߹
		$module_graph_config = ConfigFactory::createConfig( $proc_name );
		ConfigLoader::loadConfig( $module_graph_config, "module_graph" );

		// ModuleGraphȤΩƤ
		$module_graph = new ModuleGraph();
		$module_graph->build( $module_graph_config, $context );

		Logger::writeln( LogLevel::INFO,  "⥸塼륰դιۤλޤ", __FILE__, __LINE__ );

		//=======================================
		// ModuleGraphμ¹
		//
		Logger::writeln( LogLevel::INFO,  "⥸塼륰դμ¹Ԥ򳫻Ϥޤ", __FILE__, __LINE__ );

		// ⥸塼륰դΥȥΡɤstartΡɤ
		$module_graph->start();

		// ModuleGraph¹Ԥ
		while ( $module_graph->hasCurrentNode() ){

			// ߤΥΡ
			$node = $module_graph->getCurrentNode();

			// Ρɤ¹Ԥ
			$transition_key = $node->execute( $request, $context, $response );

			// ΥΡ
			$next_node = $node->getNextNode( $transition_key );

			// 褬ʤХǥե
			if ( $next_node == NULL ){
				Logger::writeln( LogLevel::INFO,  "[$transition_key]Ƥʤᡢܤޤ", __FILE__, __LINE__ );
				$transition_key = "default";
			}

			// ΥΡɤ˰ư
			$node = $module_graph->moveNext( $transition_key );

			// ܥNULLʤнλ
			if ( $node == NULL ){
				Logger::writeln( LogLevel::INFO,  "ܤλޤ", __FILE__, __LINE__ );
				break;
			}

			$next_node_name = $node->getNodeName();
			Logger::writeln( LogLevel::INFO,  "Ρ[$node_name]Ρ[$next_node_name]ܤޤ", __FILE__, __LINE__ );
		}

		Logger::writeln( LogLevel::INFO,  "⥸塼륰դμ¹Ԥλޤ", __FILE__, __LINE__ );

		//=======================================
		// ϥե륿μ¹
		//
		Logger::writeln( LogLevel::INFO,  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );

		if ( $this->_output_filters ){
			foreach( $this->_output_filters as $filter_name ){
				// ե륿
				$filter = FilterFactory::createFilter( $filter_name );
				// ե륿μ¹
				$filter->filter( $request, $context, $response );
			}
		}

		Logger::writeln( LogLevel::INFO,  "ϥե륿¹Ԥޤ", __FILE__, __LINE__ );

		//=======================================
		// μ¹
		//

		Logger::writeln( LogLevel::INFO,  "¹Ԥޤ", __FILE__, __LINE__ );

//print "renderer=[" . $this->_renderer . "]<BR>";

		if ( $this->_renderer && strlen($this->_renderer) > 0 ){
			$renderer = RendererFactory::createRenderer( $this->_renderer );
			if ( $renderer ){
				$renderer->render( $proc_name, $context, $response );
			}
		}

		Logger::writeln( LogLevel::INFO,  "¹Ԥޤ", __FILE__, __LINE__ );

		//=======================================
		// λ
		//

		// å¸
		if ( Profile::getGlobalConfig("USE_SESSION") ){
			$context->getSession()->save();
		}

		Logger::writeln( LogLevel::INFO,  "ץ[$proc_name]¹Ԥޤ", __FILE__, __LINE__ );
	}
}
?>