<?
/** 
* ʸ󥳡ǥϥե륿
*
* PHP version 5
*
* @package    filters
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class EncodingInputFilter implements IFilter
{
	var $_config;
	var $_output_filters;

	/*
	 * ե륿̾
	 */
	public function getFilterName(){
		return "Encoding Output Filter";
	}

	/*
	 * ե륿
	 */
	public function initFilter( $filter_config ){
	}

	/*
	 * ե륿Ԥ
	 */
	public function filter( Request $request, ModuleContext $context, Response $response ){

		Logger::writeln( LogLevel::INFO,  "EncodingInputFilter¹Ԥޤ", __FILE__, __LINE__ );

		// EncodingConverter
		$conv = new EncodingConverter( EncodingConverter::HTML_TO_PHP );

		// ModuleContextȤ򤹤٤ƥ󥳡ǥѴ
		$keys = $context->getKeys();
		foreach( $keys as $key ){
			$value = $context->get( $key );
			if ( is_string($value) ){
				$value = $conv->convertEncoding($value);
				$context->set( $key, $value );
			}
			else if ( is_array($value) ){
				$this->_convertEncodingArray( $value, $conv, 1 );
			}
		}

		Logger::writeln( LogLevel::INFO,  "EncodingInputFilter¹Ԥλޤ", __FILE__, __LINE__ );

	}

	/*
	 * Υ󥳡ǥѴʺƵ᥽åɡ
	 */
	private function _convertEncodingArray( $ary, EncodingConverter $conv, $level ){

		foreach( $ary as $key => $value ){
			if ( is_string($value) ){
				$value = $conv->convertEncoding($value);
				$ary[ $key ] = $value;
			}
			else if ( is_array($value) ){
				$this->_convertEncodingArray( $value, $conv, $level + 1 );
			}
		}

	}

}

?>