<?php
/**
* ե졼㳰δ쥯饹
*
* PHP version 5
*
* @package    exceptions
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/


class FrameworkException extends Exception
{
	private $_cause;
	private $_backtrace;

	public function __construct( $message, Exception $cause = null )
	{
		parent::__construct( $message );

		$this->_cause = $cause;
		$this->_backtrace = debug_backtrace();
	}

	/**
	 *   㳰
	 */
	public function getCause()
	{
		return $this->_cause;
	}

	/**
	 *   饹̾
	 */
	static function getClassName()
	{
		return __CLASS__;
	}

	/**
	 *   㳰ꥹ
	 */
	public function getCauseList()
	{
		return self::makeCauseList( $this );
	}

	/**
	 *   Хåȥ졼
	 */
	public function getBackTrace()
	{
		return $this->_backtrace;
	}

	/*
	 * 㳰θꥹȤ
	 */
	public static function makeCauseList( Exception $e ){
		if ( $e instanceof FrameworkException ){
			// ˸Фɲ
			if ( $e->getCause() ){
				$cause_list = self::makeCauseList( $e->getCause() );
				if ( $cause_list ){
					$cause_list[] = $e;
					return $cause_list;
				}
			}
			return array( $e );
		}
		return array( $e );
	}
}

?>
