<?php
/**
* ץեȥ꡼饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class ProcedureFactory
{
	/*
	 * ץ
	 */
	public static function createProcedure( $procedure_name ){

		Logger::writeln( LogLevel::INFO,  "ץ[$procedure_name]ɤޤ", __FILE__, __LINE__ );

		// ConfigFactoryˤConfig
		$proc_config = ConfigFactory::createConfig( $procedure_name );

		// ProcedureConfig
		$config_file = ConfigLoader::loadConfig( $proc_config, "procedure" );

		// 饹̾
		$class_name = $proc_config->getConfig( 'class_name' );

		if ( !$class_name ){
			throw new ProcedureConfigException( $procedure_name, 'class_name', $config_file );
		}

		// ץΥ󥹥
		$procedure = new $class_name();

		// 󥹥󥹤Iprocedure󥿥եƤ뤫ǧ
		if ( !($procedure instanceof IProcedure) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IProcedure" );
		}

		Logger::writeln( LogLevel::INFO,  "ץ[$procedure_name]ޤ", __FILE__, __LINE__ );

		// ץ
		$procedure->initProcedure( $procedure_name, $proc_config );

		Logger::writeln( LogLevel::INFO,  "ץ[$procedure_name]ɤޤ", __FILE__, __LINE__ );

		// ɤץֵ
		return $procedure;
	}


}

?>
