<?php
/**
* ⥸塼륰դΥΡɤ륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class ModuleGraphNode 
{
	var $_node_name;
	var $_module_name;
	var $_transitions;
	var $_context_values;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_module = NULL;
		$this->_transitions = NULL;
		$this->_context_values = NULL;
	}

	/*
	 * Ρ̾
	 */
	public function getNodeName(){
		return $this->_node_name;
	}

	/*
	 * ⥸塼̾
	 */
	public function getModuleName(){
		return $this->_module_name;
	}

	/*
	 * 襭
	 */
	public function getTransitionKeys(){
		return array_keys( $this->_transitions );
	}

	/*
	 * 
	 */
	public function getNextNode( $transition_key ){
		return $this->_transitions[ $transition_key ];
	}

	/*
	 * Ρɤ
	 */
	public function create( $node_name, $node_config ){

		Logger::writeln( LogLevel::INFO,  "Ρ[$node_name]ޤ", __FILE__, __LINE__ );

		// 
		$transitions = $node_config[ "next" ];

		if ( !$transitions ){
			throw new ModuleGraphConfigException( $config->getConfigPath(), "next" );
		}

		// ⥸塼̾
		$module_name = $node_config[ "module_name" ];

		// ⥸塼륳ƥͤ
		$context_values = $node_config[ "context" ];

		$this->_node_name = $node_name;
		$this->_module_name = $module_name;
		$this->_transitions = $transitions;
		$this->_context_values = $context_values;
	}

	/*
	 * ƥͤ򥤥󥸥Ȥ
	 */
	private function injectContext( ModuleContext $context ){
		if ( !$this->_context_values ){
			return;
		}

		foreach( $this->_context_values as $key => $value ){
			Logger::writeln( LogLevel::DEBUG,  "Ρ[$node_name][$key:$value]", __FILE__, __LINE__ );
			$context->set( $key, $value );
			Logger::writeln( LogLevel::DEBUG,  "Ρ[$node_name]ǥƥ[$key:$value]injectޤ", __FILE__, __LINE__ );
		}
	}

	/*
	 * Ρɤ¹Ԥ
	 */
	public function execute( Request $request, ModuleContext $context, Response $response )
	{
		try{
			// ƥͤ򥤥󥸥Ȥ
			$this->injectContext($context);

			// Ρ̾ȥ⥸塼̾
			$node_name = $this->_node_name;
			$module_name = $this->_module_name;

			Logger::writeln( LogLevel::INFO,  "Ρ[$node_name]¹Ԥޤ", __FILE__, __LINE__ );

			// ⥸塼Υ
			$module = ModuleFactory::createModule( $module_name );

			// ⥸塼μ¹
			Logger::writeln( LogLevel::INFO,  "⥸塼[$module_name]¹Ԥޤ", __FILE__, __LINE__ );

	//			try{
				$transition_key = $module->execute( $request, $context, $response );

	/*			}
			catch( Exception $e ){
				// 㳰
				$exception_name = get_class($e);
				Logger::writeln( LogLevel::INFO,  "㳰[$exception_name]catchޤ", __FILE__, __LINE__ );
				$transition_key = "exception";
				// ⥸塼륳ƥȤ㳰Ƥ򥳥ԡ
				$context->set( "exception", $e );
			}
	*/

			Logger::writeln( LogLevel::INFO,  "⥸塼[$module_name]¹Ԥޤ=[$transition_key]", __FILE__, __LINE__ );

			return $transition_key;
		}
		catch ( Exception $e ){
			throw new ModuleGraphNodeException( $this, "ModuleGraphNode#execute() failed", $e );
		}
	}

}

?>