<?php
/**
* ⥸塼륰դ륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class ModuleGraph 
{
	var $_module_graph;
	var $_current_node;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_current_node = NULL;
		$this->_module_graph = array();
	}

	/*
	 * Ρ̾
	 */
	public function getNodeNames(){
		return array_keys( $this->_module_graph );
	}

	/*
	 * Ρ̾бΡɤ
	 */
	public function getNode( $node_name ){
		return $this->_module_graph[ $node_name ];
	}

	/*
	 * startΡɤ¹Ԥ򳫻Ϥ
	 */
	public function start(){

		$start_node = "start";

		Logger::writeln( LogLevel::INFO,  "⥸塼륰դθߥΡɤ[$start_node]ꤷޤ", __FILE__, __LINE__ );

		$this->_current_node = $this->_module_graph[ $start_node ];

//		DebugUtil::dumpModuleGraph( $this, "start" );

	}

	/*
	 * ߤΥΡɤ뤫
	 */
	public function hasCurrentNode(){
		return ($this->_current_node != NULL);
	}

	/*
	 * ߤΥΡ
	 */
	public function getCurrentNode(){
		return $this->_current_node;
	}

	/*
	 * Ρɤܤ
	 */
	public function moveNext( $transition_key ){

		// ΥΡ̾
		$next_node_name = $this->_current_node->getNextNode( $transition_key );

		// 褬̤ʤ㳰
		if ( $next_node_name == NULL ){
			throw new ModuleGraphTransitionException( $this->_current_node->getNodeName(), $transition_key );
		}

		// ߤΥΡɤ򹹿
		$this->_current_node = $this->_module_graph[ $next_node_name ];

		// ߤΥΡɤֵ
		return $this->_current_node;
	}

	/*
	 * ⥸塼륰դ
	 */
	public function build( IConfig $config, ModuleContext $context ){

		Logger::writeln( LogLevel::INFO,  $config->getConfigPath() . "⥸塼륰դιۤ򳫻Ϥޤ", __FILE__, __LINE__ );

		$this->_current_node = NULL;
		$this->_module_graph = array();

		// Ρ̾
		$node_name_list= $config->getKeys();

		// ƥΡɤΥ⥸塼ɤ߹
		foreach( $node_name_list as $node_name ){

			Logger::writeln( LogLevel::INFO,  "Ρ[$node_name]ɤ߹ߤޤ", __FILE__, __LINE__ );

			// ꤫Ρɾ
			$node_config = $config->getConfig( $node_name );

//print gettype($transitions);

			// եΡɤ
			$graph_node = new ModuleGraphNode();
			$graph_node->create( $node_name, $node_config );

			// ⥸塼륰դ˥եΡɤɲ
			$this->_module_graph[ $node_name ] = $graph_node;
		}

	}


}

?>
