<?php
/**
* ⥸塼եȥꥯ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class ModuleFactory
{
	var $_name;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_name = NULL;
	}

	/*
	 * ⥸塼
	 */
	public static function createModule( $module_name ){

		Logger::writeln( LogLevel::INFO,  "⥸塼[$module_name]ɤޤ", __FILE__, __LINE__ );

		// ⥸塼եɤ߹
		$module_config = ConfigFactory::createConfig( $module_name );
		ConfigLoader::loadConfig( $module_config, "module" );

		// 饹̾
		$class_name = $module_config->getConfig( "class_name" );

		// ⥸塼Υ󥹥
		$module = new $class_name();

		// 󥹥󥹤IModule󥿥եƤ뤫ǧ
		if ( !($module instanceof IModule) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IModule" );
		}

		Logger::writeln( LogLevel::INFO,  "⥸塼[$module_name]ޤ", __FILE__, __LINE__ );

		// ⥸塼
		$module->initModule( $module_config );

		Logger::writeln( LogLevel::INFO,  "⥸塼[$module_name]ɤޤ", __FILE__, __LINE__ );

		// ɤ⥸塼ֵ
		return $module;
	}


}

?>
