<?php
/**
* Υեȥɥ󥿥ե
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Logger 
{
	var $_loggers;
	var $_enabled;

	/*
	 *    󥹥ȥ饯
	 */
	private function __construct()
	{
		$this->_loggers = array();

		$this->_enabled = (Profile::getGlobalConfig("LOGGING") == 1);
	}

	/*
	 *    ͣΥ󥹥󥹼
	 */
	public static function &getInstance()
	{
		static $singleton_;
		if ( $singleton_ == null ){
			$singleton_ = new Logger();
		}
		return $singleton_;
	}

	/*
	 *	եϿ
	 */
	public static function registerFileLogger( $key, $file_name ){

		if ( !self::isEnabled() ){
			return;
		}
		
		// եݡͥȤ˥ѥ򥻥å
		$logfile_path = ResourceLocator::getPath( ResourcePath::LOGS, $file_name );

		// Ͽ
		self::registerLogger( $key, new FileLogger($logfile_path) );
	}

	/*
	 *	Ͽ
	 */
	public static function registerLogger( $key, ILogger $logger ){
		
		if ( !self::isEnabled() ){
			return;
		}
		
		// 󥹥󥹤μ
		$ins = & self::getInstance();

		// ˥å
		$ins->_loggers[ $key ] = $logger;

		// syslogʳʤ顢syslog˽
		if ( $key != LogType::SYSTEM && $ins->_loggers[ LogType::SYSTEM ] ){
			$logger_name = $logger->getLoggerName();
			$ins->_loggers[ LogType::SYSTEM ]->writeln( "[$logger_name]LoggerϿޤʥ:$keyˡ", __FILE__, __LINE__ );
		}
	}

	/*
	 *	Խ
	 */
	public static function writeln( $log_level, $message, $file, $line, EncodingConverter $conv = NULL ){

		if ( !self::isEnabled() ){
			return;
		}
		
		// LogLevelLogTypeȽ
		$log_type = self::logLevelToLogType( $log_level );

		$logger = self::getLogger( $log_type );

		if ( $logger ){
			$logger->writeln( $message, $file, $line, $conv );
		}
		
	}
	

	/*
	 *	
	 */
	public static function writeArray( $log_level, $ary, $file, $line, EncodingConverter $conv = NULL ){
		
		if ( !self::isEnabled() ){
			return;
		}

		// LogLevelLogTypeȽ
		$log_type = self::logLevelToLogType( $log_level );

		$logger = self::getLogger( $log_type );

		if ( $logger ){
			$logger->writeArray( $ary, $file, $line, $conv );
		}
		
	}
	
	/*
	 *	
	 */
	private static function logLevelToLogType( $log_level ){

		switch ( $log_level ){
		case LogLevel::FATAL:
		case LogLevel::ERROR:
			$log_type = LogType::APP;
			break;
		case LogLevel::WARNING:
		case LogLevel::INFO:
			$log_type = LogType::SYSTEM;
			break;
		case LogLevel::DEBUG:
		case LogLevel::TRACE:
			$log_type = LogType::DEBUG;
			break;
		case LogLevel::SQL:
			$log_type = LogType::SQL;
			break;
		case LogLevel::APP:
			$log_type = LogType::APP;
			break;
		default:
			// TODO: 㳰
			break;
		}

		return $log_type;
	}
	
	/*
	 *	ϥե饰
	 */
	private static function isEnabled(){
		// 󥹥󥹤μ
		$ins = & self::getInstance();

		return $ins->_enabled;
	}

	/*
	 *	
	 */
	private static function getLogger( $log_type ){
		
		// 󥹥󥹤μ
		$ins = & self::getInstance();

		// 󤫤
		$logger = $ins->_loggers[ $log_type ];

		// ʤϺ
		if ( $logger == NULL ){
			switch ( $log_type ){
			case LogType::APP:		$component_name = "charcoal:AppLogger";		break;
			case LogType::SQL:		$component_name = "charcoal:SqlLogger";		break;
			case LogType::DEBUG:	$component_name = "charcoal:DebugLogger";	break;
			}
			if ( $component_name ){
				$logger = DIContainer::getComponent( $component_name );
			}
		}

		return $logger;
	}

}

?>