<?php
/**
* ե졼ѥ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class FrameworkClassLoader
{
	static $class_paths;

	/*
	 * 饹ѥν
	 */
	public static function initClassPath()
	{
		if ( !self::$class_paths ){

			self::$class_paths = array(

			// core classes
					"Benchmark"			=> "core/Benchmark.class.php",
					"ClassLoaderFactory"=> "core/ClassLoaderFactory.class.php",
					"ConfigFactory"		=> "core/ConfigFactory.class.php",
					"ConfigLoader"		=> "core/ConfigLoader.class.php",
					"ConfigUtil"		=> "core/ConfigUtil.class.php",
					"DebugUtil"			=> "core/DebugUtil.class.php",
					"DIContainer"		=> "core/DIContainer.class.php",
					"DispatcherFactory"	=> "core/DispatcherFactory.class.php",
					"EncodingConverter"	=> "core/EncodingConverter.class.php",
					"FileLogger"		=> "core/FileLogger.class.php",
					"FilterFactory"		=> "core/FilterFactory.class.php",
					"FormFactory"		=> "core/FormFactory.class.php",
					"Framework"			=> "core/Framework.class.php",
					"Logger"			=> "core/Logger.class.php",
					"ModuleContext"		=> "core/ModuleContext.class.php",
					"ModuleFactory"		=> "core/ModuleFactory.class.php",
					"ModuleGraph"		=> "core/ModuleGraph.class.php",
					"ModuleGraphNode"	=> "core/ModuleGraphNode.class.php",
					"ProcedureFactory"	=> "core/ProcedureFactory.class.php",
					"Profile"			=> "core/Profile.class.php",
					"RendererFactory"	=> "core/RendererFactory.class.php",
					"Request"			=> "core/Request.class.php",
					"ResourceLocator"	=> "core/ResourceLocator.class.php",
					"Response"			=> "core/Response.class.php",
					"ScreenLogger"		=> "core/ScreenLogger.class.php",
					"System"			=> "core/System.class.php",
					"URL"				=> "core/URL.class.php",
					"ValidatorFactory"	=> "core/ValidatorFactory.class.php",
					"Session"			=> "core/Session.class.php",

			// interface classes
					"IComponent"		=> "interfaces/IComponent.class.php",
					"IClassLoader"		=> "interfaces/IClassLoader.class.php",
					"IConfig"			=> "interfaces/IConfig.class.php",
					"IDispatcher"		=> "interfaces/IDispatcher.class.php",
					"IFilter"			=> "interfaces/IFilter.class.php",
					"IForm"				=> "interfaces/IForm.class.php",
					"ILogger"			=> "interfaces/ILogger.class.php",
					"IModule"			=> "interfaces/IModule.class.php",
					"IProcedure"		=> "interfaces/IProcedure.class.php",
					"IRenderer"			=> "interfaces/IRenderer.class.php",
					"IValidator"		=> "interfaces/IValidator.class.php",

			// constant classes
					"ComponentScope"	=> "constants/ComponentScope.class.php",
					"LogLevel"			=> "constants/LogLevel.class.php",
					"LogType"			=> "constants/LogType.class.php",
					"ResourcePath"		=> "constants/ResourcePath.class.php",

			// exception classes
					"ComponentConfigException"			=> "exceptions/ComponentConfigException.class.php",
					"ComponentNotRegisteredException"	=> "exceptions/ComponentNotRegisteredException.class.php",
					"ConfigFileNotFoundException"		=> "exceptions/ConfigFileNotFoundException.class.php",
					"FileNotFoundException"				=> "exceptions/FileNotFoundException.class.php",
					"FrameworkException"				=> "exceptions/FrameworkException.class.php",
					"InterfaceImplementException"		=> "exceptions/InterfaceImplementException.class.php",
					"ModuleException"					=> "exceptions/ModuleException.class.php",
					"ModuleGraphConfigException"		=> "exceptions/ModuleGraphConfigException.class.php",
					"ModuleGraphTransitionException"	=> "exceptions/ModuleGraphTransitionException.class.php",
					"ModuleGraphNodeException"			=> "exceptions/ModuleGraphNodeException.class.php",
					"NonObjectException"				=> "exceptions/NonObjectException.class.php",
					"NullPointerException"				=> "exceptions/NullPointerException.class.php",
					"ParameterException"				=> "exceptions/ParameterException.class.php",
					"ProcedureConfigException"			=> "exceptions/ProcedureConfigException.class.php",
					"ProfileException"					=> "exceptions/ProfileException.class.php",
					"TemplateFileNotFoundException"		=> "exceptions/TemplateFileNotFoundException.class.php",
					"RendererException"					=> "exceptions/RendererException.class.php",
					"ClassNotDefinedException"			=> "exceptions/ClassNotDefinedException.class.php",

			// config classes
					"SpycConfig"						=> "configs/SpycConfig.class.php",
					"CachedSpycConfig"					=> "configs/CachedSpycConfig.class.php",

			// dispatcher classes
					"SimpleDispatcher"					=> "dispatchers/SimpleDispatcher.class.php",

			// procedure classes
					"ModuleGraphProcedure"				=> "procedures/ModuleGraphProcedure.class.php",

			// renderer classes
					"SmartyRenderer"					=> "renderers/SmartyRenderer.class.php",
					"PhpTalRenderer"					=> "renderers/PhpTalRenderer.class.php",

			// filter classes
					"EncodingInputFilter"				=> "filters/EncodingInputFilter.class.php",
					"EncodingOutputFilter"				=> "filters/EncodingOutputFilter.class.php",
					"CharcoalPagerOutputFilter"			=> "filters/CharcoalPagerOutputFilter.class.php",

			// component classes
					"DebugLogger"						=> "components/charcoal/DebugLogger.class.php",
					"AppLogger"							=> "components/charcoal/AppLogger.class.php",
					"SqlLogger"							=> "components/charcoal/SqlLogger.class.php",
					"Linker"							=> "components/charcoal/Linker.class.php",
					"BreadcrumbList"					=> "components/charcoal/BreadcrumbList.class.php",
					"CharcoalPager"						=> "components/charcoal/CharcoalPager.class.php",
					"Calendar"							=> "components/charcoal/Calendar.class.php",
					"DataGateway"						=> "components/db/DataGateway.class.php",
					"DataSource"						=> "components/db/DataSource.class.php",
					"ResultSetLogger"					=> "components/db/ResultSetLogger.class.php",
					"CharcoalMail"						=> "components/mail/CharcoalMail.class.php",
					"CompatInfo"						=> "components/pear/CompatInfo.class.php",
			);
		}

		return self::$class_paths;
	}

	/*
	 * 饹
	 */
	public static function loadClass( $class_name )
	{

//$bench = new Benchmark();

		// 饹ѥν
		$class_paths = self::initClassPath();

//print "class_name=$class_name<BR>";
		// 饹̾饯饹ѥ
		$classPath = $class_paths[ $class_name ];

		// ե졼Υ饹ǤϤʤFALSEֵ
		if ( !$classPath ){
			return FALSE;
		}

		// ɤ߹
//print "require_once=$classPath<BR>";
		require_once( $classPath );

//$score = $bench->stop() * 1000;

//print "loaded[$class_name] in $score msec.<BR>";

		// ˥饹ɤ߹ޤ줿å
		if ( !class_exists( $class_name ) && !interface_exists( $class_name ) ){
			require_once( 'exceptions/ClassNotFoundException.class.php' );
			throw new ClassNotDefinedException( $class_name, $classPath );
		}

		return TRUE;
	}
}
?>