<?php
/**
*  ե졼Υᥤ󥯥饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class Framework
{
	/*
	 *	ե졼ư
	 */
	public static function run()
	{
		try{
			//=======================================
			// ƥν
			//

			// ƥ
			$syslog_filepath = ResourceLocator::getPath( ResourcePath::LOGS, "system.log" );
			$syslogger = new FileLogger($syslog_filepath);

			// ƥޥ͡Ͽ
			Logger::registerLogger( LogType::SYSTEM, $syslogger );

			// ưå
			Logger::writeln( LogLevel::INFO, "===========================================================", __FILE__, __LINE__ );
			Logger::writeln( LogLevel::INFO, " CHARCOAL framework version 1.0 (c)sazysoft,stk2k          ", __FILE__, __LINE__ );
			Logger::writeln( LogLevel::INFO, "===========================================================", __FILE__, __LINE__ );

			Logger::writeln( LogLevel::INFO, "charcoalե졼򳫻Ϥޤ", __FILE__, __LINE__ );

			//=======================================
			// Requestѥ᡼μ
			//

			Logger::writeln( LogLevel::INFO, "Requestѥ᡼βϤ򳫻Ϥޤ", __FILE__, __LINE__ );

			// Request֥Ȥ
			$request = new Request();
			$request->load();

			Logger::writeln( LogLevel::INFO, "ץ㥭[$proc]Ǥ", __FILE__, __LINE__ );

			//=======================================
			// ꥯȥǥѥå
			//

			Logger::writeln( LogLevel::INFO, "Dispatch򳫻Ϥޤ", __FILE__, __LINE__ );

			// ǥѥå̾ե뤫
			$dispacher_name = Profile::getGlobalConfig( "DISPATCHER" );

			// ǥѥå
			$dispatcher = DispatcherFactory::createDispatcher( $dispacher_name );

			// ǥѥå
			$proc = $dispatcher->dispatch( $request );

//print "proc:$proc<BR>";
//print "id:" . $request->get("id") . "<BR>";

			Logger::writeln( LogLevel::INFO, "Dispatchλޤǥѥå=[$proc]", __FILE__, __LINE__ );

			//=======================================
			// Procedureκ
			//

			Logger::writeln( LogLevel::INFO, "ץ[$proc]ޤ", __FILE__, __LINE__ );

			// ץ
			$procedure = ProcedureFactory::createProcedure( $proc );

			Logger::writeln( LogLevel::INFO, "ץ[$proc]ޤ", __FILE__, __LINE__ );

			//=======================================
			// ƥʤκȵư
			//

			Logger::writeln( LogLevel::INFO, "DIƥʤκ򳫻Ϥޤ", __FILE__, __LINE__ );

			// DIƥʤ
			DIContainer::createContainer( $procedure );

			//=======================================
			// Responseκ
			//

			Logger::writeln( LogLevel::INFO, "Response֥Ȥޤ", __FILE__, __LINE__ );

			// Request֥Ȥ
			$response = new Response();

			//=======================================
			// ModuleContextκ
			//

			Logger::writeln( LogLevel::INFO, "ModuleContext֥Ȥޤ", __FILE__, __LINE__ );

			// ModuleContext֥Ȥ
			$context = new ModuleContext();

			//=======================================
			// Procedureμ¹
			//

			Logger::writeln( LogLevel::INFO, "ץ[$proc]¹Ԥޤ", __FILE__, __LINE__ );

			// ץμ¹
			$procedure->execute( $request, $context, $response );

			Logger::writeln( LogLevel::INFO, "ץ[$proc]¹Ԥޤ", __FILE__, __LINE__ );

			//=======================================
			// ƥʤ˴
			//

			Logger::writeln( LogLevel::INFO, "DIƥʤ˴ޤ", __FILE__, __LINE__ );

			DIContainer::destroy();

			//=======================================
			// λ
			//

			// ưå
			Logger::writeln( LogLevel::INFO, "charcoalե졼λޤ", __FILE__, __LINE__ );
		}
		catch ( FrameworkException $e ){

			$cause_list = $e->getCauseList();

			$cause_list[] = new FrameworkException( "Framework#run() failed", $e );

			print '<HTML>' . "\r";
			print '<HEAD>' . "\r";
			print '<META http-equiv="Content-Type" content="text/html; charset=EUC-JP">' . "\r";
			print '<LINK rel="stylesheet" href="css/error.css" type="text/css">' . "\r";
			print '</HEAD>' . "\r";
			print '<BODY>' . "\r";

			// 㳰ꥹ
			print '<TABLE class="error_detail">' . "\r";
			print '<TR>' . "\r";
			print '	  <TH class="error_detail">٥</TH>' . "\r";
			print '	  <TH class="error_detail">㳰</TH>' . "\r";
			print '	  <TH class="error_detail">å</TH>' . "\r";
			print '	  <TH class="error_detail"></TH>' . "\r";
			print '	  <TH class="error_detail">ֹ</TH>' . "\r";
			print '</TR>' . "\r";

			$level = 0;
			foreach( $cause_list as $cause ){
				$class_name = get_class($cause);
				$message 	= $cause->getMessage();
				$file 		= basename($cause->getFile());
				$line 		= $cause->getLine();
				print '<TR>' . "\r";
				print '   <TD class="error_detail">' . $level . '</TD>' . "\r";
				print '   <TD class="error_detail">' . $class_name . '</TD>' . "\r";
				print '   <TD class="error_detail">' . $message . '</TD>' . "\r";
				print '   <TD class="error_detail">' . $file . '</TD>' . "\r";
				print '   <TD class="error_detail">' . $line . '</TD>' . "\r";
				print '</TR>' . "\r";
				$level ++;
			}
			print '</TABLE>' . "\r";

			print '<P>' . "\r";

			foreach( $cause_list as $cause ){

				if ( $cause instanceof FrameworkException ){

					$backtraces = $cause->getBackTrace();

					// Хåȥ졼
					print '<TABLE class="error_detail">' . "\r";
					print '<TR>' . "\r";
					print '	  <TH class="error_detail">ؿ̾</TH>' . "\r";
					print '	  <TH class="error_detail">ե̾(ֹ)</TH>' . "\r";
					print '	  <TH class="error_detail"></TH>' . "\r";
					print '</TR>' . "\r";

					$level = 0;
					foreach( $backtraces as $trace ){
						$func 	= $trace[ 'class' ] . "::" . $trace[ 'function' ];
						$line 	= $trace[ 'line' ];
						$dir	= dirname($trace[ 'file' ]);
						$file 	= basename($trace[ 'file' ]);
						$args	= $trace[ 'args' ];
						print '<TR>' . "\r";
						print '   <TD class="error_detail">' . $func . '</TD>' . "\r";
						print '   <TD class="error_detail">' . $dir . '<BR>' . $file . '(' . $line . ')</TD>' . "\r";
						print '   <TD class="error_detail">' . System::arrayToString($args) . '</TD>' . "\r";
						print '</TR>' . "\r";
						$level ++;
					}
					print '</TABLE>' . "\r";
					break;
				}
			}

			print '</BODY>' . "\r";
			print '</HTML>' . "\r";

		}

	}
}
?>