<?php
/**
* ե˽Ϥ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class FileLogger implements ILogger
{
	private $_open;
	private $_fp;
	private $_file_name;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct( $file_name = NULL )
	{
		$this->_open = false;
		$this->_fp = null;
		$this->_file_name = $file_name;
	}

	/*
	 * ǥȥ饯
	 */
	public function __destruct()
	{
		$this->close();
	}

	/*
	 * ̾
	 */
	public function getLoggerName(){
		return "File Logger";
	}

	/*
	 * ե̾
	 */
	public function setFileName( $file_name ){
		$this->_file_name = $file_name;
	}

	/*
	 * ե̾
	 */
	public function getFileName(){
		return $this->_file_name;
	}

	/*
	 * ե뤬ץ󤵤Ƥ뤫
	 */
	public function isOpen()
	{
		return $this->_open;
	}

	/*
	 * ե򥪡ץ󤹤
	 */
	public function open()
	{
		// Ǥ˳Ƥʤʤˤ⤷ʤ
		if ( $this->_open ){
			return;
		}
		$this->_fp = fopen($this->_file_name, "a");
		$this->_open = true;
	}

	/*
	 * եĤ
	 */
	public function close()
	{
		if ( $this->_fp != null ){
			fclose ($this->_fp);
			$this->_fp = null;
		}
		$this->_open = false;
	}

	/*
	 * Խ
	 */
	public function writeln( $message, $file = NULL, $line = NULL, EncodingConverter $conv = NULL )
	{
		$time = date("Y/m/d H:i:s");
		$file = basename($file);

		// 󥳡ǥѴ
		if ( $conv == NULL ){
			$conv = new EncodingConverter( EncodingConverter::PHP_TO_LOG );
		}
		$message = $conv->convertEncoding( $message );

		// ³
		$this->open();

		// ե񤭹
		fwrite ($this->_fp, "[$time] $message                                 @$file($line) \n"); 
	}


	/*
	 * 
	 */
	public function writeArray( $ary, $file = NULL, $line = NULL, EncodingConverter $conv = NULL )
	{
		// NULLϤ줿ϲ⤷ʤ
		if ( $ary == NULL ){
			return;
		}
		// Ǥʤ㳰
		if ( !is_array($ary) ){
			throw new ParameterException( "ary", gettype(ary), "must be ana array" );
		}

		$time = date("Y/m/d H:i:s");
		$file = basename($file);

//print "conv:$conv<BR>";
//print "ary:" . System::arrayToString($ary) . "<BR>";

		// 󥳡ǥѴ
		if ( $conv == NULL ){
			$conv = new EncodingConverter( EncodingConverter::PHP_TO_LOG );
		}
		$ary = $conv->convertEncodingArray( $ary );

//print "writeArray:" . $conv->getFromEncoding() . " => " . $conv->getToEncoding() . "<BR>";

		// ³
		$this->open();

		// Ŀ
		$cnt = count( $ary );

		for( $i=0; $i<$cnt; $i++ ){
			$item = $ary[ $i ];
			// ե񤭹
			$message = "[$time] \t\t[$i]$item \n";
//print "message:$message<BR>";
			fwrite ($this->_fp, $message); 
		}

	}

}

?>
