<?php
/**
* ʸ󥳡ǥѴ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class EncodingConverter
{
	//==========================================
	//	Converter Types
	//==========================================
	const NO_CONVERT		= 0;
	const PHP_TO_DB  		= 1;
	const PHP_TO_HTML  		= 2;
	const PHP_TO_LOG  		= 3;
	const HTML_TO_PHP  		= 4;
	const DB_TO_PHP  		= 5;
	const DB_TO_HTML  		= 6;
	const DB_TO_LOG	  		= 7;
	const HTML_TO_DB  		= 8;
	const PHP_TO_MAIL		= 9;

	var $_type;
	var $_from;
	var $_to;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct( $type )
	{
		$this->_type = $type;
		$this->setEncodingSettings();
	}

	/*
	 *	Ѵ
	 */
	public function convertEncoding( $str ){
		if ( $this->_type == EncodingConverter::NO_CONVERT ){
			return $str;
		}
//print "EncodingConvert:" . $this->_from . "-->" . $this->_to . " message:" . $str . "<BR>";
//print "EncodingConvert:" . $this->_type . " message:" . $str . "<BR>";

		return mb_convert_encoding( $str, $this->_to, $this->_from );
	}

	/*
	 *	Ѵ
	 */
	public function convertEncodingArray( $ary ){

		if ( $ary == NULL ){
			throw new NullPointerException( $ary );
		}
		if ( !is_array($ary) ){
			throw new ParameterException( "ary", gettype($ary), "must be an array" );
		}

		$new_array = array();

		foreach( $ary as $value ){
			$new_value = mb_convert_encoding( $value, $this->_to, $this->_from );
//print "convertEncodingArray:" . $value . " => " . $new_value . "<BR>";
			$new_array[] = $new_value;
		}

		return $new_array;
	}

	/*
	 *	ʸƵŪѴ
	 */
	public function convertEncodingRecursive( $data )
	{
		if ( $data == NULL ){
			throw new NullPointerException( $ary );
		}
		if ( is_array($data) ){
			foreach( $data as $key => $value ){
				$value = $this->convertEncodingRecursive( $value );
				$data[$key] = $value;
			}
		}
		else if ( is_string($data) ){
			$data = $this->convertEncoding( $data );
		}

		return $data;
	}

	/*
	 *	Ѵפ
	 */
	public function getType(){
		return $this->_type;
	}

	/*
	 *	Ѵʸɤ
	 */
	public function getFromEncoding(){
		return $this->_from;
	}

	/*
	 *	Ѵʸɤ
	 */
	public function getToEncoding(){
		return $this->_to;
	}

	/*
	 *	ʸѴ
	 */
	public function __toString(){
		return "[EncodingConverter]" . $this->_from . " TO " . $this->_to;
	}

	/*
	 *	ѴѴʸɤȽ
	 */
	private function setEncodingSettings(){

		// Ѵ
		switch( $this->_type ){
		case EncodingConverter::PHP_TO_DB:
		case EncodingConverter::PHP_TO_HTML:
		case EncodingConverter::PHP_TO_LOG:
		case EncodingConverter::PHP_TO_MAIL:
			$this->_from = Profile::getGlobalConfig('PHP_CODE');
			break;

		case EncodingConverter::HTML_TO_PHP:
		case EncodingConverter::HTML_TO_DB:
			$this->_from = Profile::getGlobalConfig('HTML_CODE');
			break;

		case EncodingConverter::DB_TO_PHP:
		case EncodingConverter::DB_TO_HTML:
		case EncodingConverter::DB_TO_LOG:
			$this->_from = Profile::getGlobalConfig('DB_CODE');
			break;
		}

		// Ѵ
		switch( $this->_type ){
		case EncodingConverter::PHP_TO_LOG:
		case EncodingConverter::DB_TO_LOG:
			$this->_to = Profile::getGlobalConfig('LOG_CODE');
			break;

		case EncodingConverter::HTML_TO_PHP:
		case EncodingConverter::DB_TO_PHP:
			$this->_to = Profile::getGlobalConfig('PHP_CODE');
			break;

		case EncodingConverter::DB_TO_HTML:
		case EncodingConverter::PHP_TO_HTML:
			$this->_to = Profile::getGlobalConfig('HTML_CODE');
			break;

		case EncodingConverter::PHP_TO_DB:
		case EncodingConverter::HTML_TO_DB:
			$this->_to = Profile::getGlobalConfig('DB_CODE');
			break;

		case EncodingConverter::PHP_TO_MAIL:
			$this->_to = "ISO-2022-JP";
			break;

		}


	}

}

?>
