<?php
/**
*  ǥХå˴ؤ桼ƥƥ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class DebugUtil
{

	/*
	 * եƤ
	 */
	public static function dumpConfig( $config, $title, $section = TRUE ){

		Logger::writeln( LogLevel::DEBUG, "----------------------------------------------------", __FILE__, __LINE__ );
		Logger::writeln( LogLevel::DEBUG, "$title config", __FILE__, __LINE__ );
		Logger::writeln( LogLevel::DEBUG, "----------------------------------------------------", __FILE__, __LINE__ );

		foreach( $config as $key => $value ){

			// sectionե饰TRUEʤ顢쳬ؤϥ̾
			if ( $section ){
				Logger::writeln( "[$key]", __FILE__, __LINE__ );

				if ( is_array($value) ){
					foreach( $value as $key2 => $value2 ){
						Logger::writeln( LogLevel::DEBUG, "$key2=$value2", __FILE__, __LINE__ );
					}
				}
			}
			else{
				// =
				Logger::writeln( LogLevel::DEBUG, "$key=$value", __FILE__, __LINE__ );
			}
		}

		Logger::writeln( LogLevel::DEBUG, "----------------------------------------------------", __FILE__, __LINE__ );
	}

	/*
	 * ⥸塼륰դƤ
	 */
	public static function dumpModuleGraph( ModuleGraph $module_graph, $title ){

		Logger::writeln( LogLevel::DEBUG, "----------------------------------------------------", __FILE__, __LINE__ );
		Logger::writeln( LogLevel::DEBUG, "$title", __FILE__, __LINE__ );
		Logger::writeln( LogLevel::DEBUG, "----------------------------------------------------", __FILE__, __LINE__ );

		// Ρ̾
		$name_list = $module_graph->getNodeNames();

		foreach( $name_list as $name ){

			// Ρ
			$node = $module_graph->getNode( $name );

			// ⥸塼̾
			$module_name = $node->getModuleName();

			// Ρɾ
			Logger::writeln( LogLevel::DEBUG, $name . "[" . $module_name . "]", __FILE__, __LINE__ );

			// 
			$tr_keys = $node->getTransitionKeys();
			foreach( $tr_keys as $key ){

				// 
				$next_node = $node->getNextNode( $key );

				// 
				Logger::writeln( LogLevel::DEBUG, "\t [$key] => $next_node", __FILE__, __LINE__ );
			}
		}

		Logger::writeln( LogLevel::DEBUG, "----------------------------------------------------", __FILE__, __LINE__ );
	}
}

?>
