<?php
/**
* DIƥʥ饹
*
* ܺ
* ƥʤεǽ륯饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class DIContainer 
{
	var $_components;
	var $_component_configs;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_components = array();
		$this->_component_configs = array();
	}

	/*
	 *    ͣΥ󥹥󥹼
	 */
	private static function &getInstance()
	{
		static $singleton_;
		if ( $singleton_ == null ){
			$singleton_ = new DIContainer();
		}
		return $singleton_;
	}

	/**
	 * DIƥʤ
	**/
	public static function createContainer( IProcedure $procedure ){

		Logger::writeln( LogLevel::INFO,  "DIƥʤν򳫻Ϥޤ", __FILE__, __LINE__ );

		// 󥹥󥹤μ
		$container = & DIContainer::getInstance();

		// ==================================================
		// ݡͥեɤ߹
		// ==================================================

		// ݡͥեΥѥ
		$component_config_file = ResourceLocator::getPath( ResourcePath::CONFIG, "component_defs.ini" );

		// sectionդiniեѡ
		$container->component_config_files = parse_ini_file($component_config_file,TRUE);

		Logger::writeln( LogLevel::INFO,  "DIƥʤνλޤ", __FILE__, __LINE__ );

	}

	/*
	 * DIƥʤ˴
	 */
	public static function destroy(){

		Logger::writeln( LogLevel::INFO,  "DIƥʤ˴򳫻Ϥޤ", __FILE__, __LINE__ );

		// 󥹥󥹤μ
		$container = & DIContainer::getInstance();

		// ݡͥȤ˴
		$container->destroyComponents();

		Logger::writeln( LogLevel::INFO,  "DIƥʤ˴λޤ", __FILE__, __LINE__ );
	}

	/*
	 * ݡͥȤ
	 */
	public function loadComponent( $component_name ){

		Logger::writeln( LogLevel::INFO,  "ݡͥ[$component_name]ɤޤ", __FILE__, __LINE__ );

		Logger::writeln( LogLevel::INFO,  "ݡͥ[$component_name]ե[$config_file]Ǥ", __FILE__, __LINE__ );

		// ConfigFactoryˤConfig
		$component_config = ConfigFactory::createConfig( $component_name );

		// ݡͥեɤ߹
		ConfigLoader::loadConfig( $component_config, "component" );

		// å¸
		$this->_component_configs[ $component_name ] = $component_config;

		// 饹̾
		$class_name = $component_config->getConfig( "class_name" );

		// ݡͥȥפ
		$scope = $component_config->getConfig( "scope" );

//print "class_name:$class_name<BR>";

		// ݡͥȥפˤäˡѹ
		switch ( $scope ){
		case ComponentScope::TRANSIENT:
		case ComponentScope::REQUEST:
			{
				// 饹ɤ߹ߥå
				if ( !class_exists($class_name) ){
					throw new ClassNotDefinedException( $class_name );
				}
				// ݡͥȤΥ󥹥
				$component = new $class_name();
			}
			break;

		case ComponentScope::SESSION:
			{
				// ݡͥȤΥ󥹥󥹤򥻥å󤫤
				$component = unserialize( $_SESSION[ $component_name ] );

				// åˤʤС󥹥󥹤
				if ( $component == NULL ){
//print "class[$class_name]ϥå󤫤Ǥʤä<BR>";
					$component = new $class_name();
				}

			}
			break;
		}


		if ( !$component ){
			// scope˻ꤵ줿ɤ
			throw new ComponentConfigException( $component_config->getComponentConfigFile(), "scope", "invalid key word:$scope" );
		}

		// 󥹥󥹤IComponent󥿥եƤ뤫ǧ
		if ( !($component instanceof IComponent) ){
			// 㳰
			throw new InterfaceImplementException( $class_name, "IComponent" );
		}

		Logger::writeln( LogLevel::INFO,  "ݡͥ[$component_name]ޤ", __FILE__, __LINE__ );

		// ݡͥȤ
		$component->initComponent( $component_config );

		// ݡͥȤϿ
		$this->_components[ $component_name ] = $component;

		Logger::writeln( LogLevel::INFO,  "ݡͥ[$component_name]ɤޤ", __FILE__, __LINE__ );

		// ɤݡͥȤֵ
		return $component;
	}

	/*
	 * ϿѤߥݡͥȤ
	 */
	public static function getComponent( $key ){

		// 󥹥󥹤μ
		$container = & DIContainer::getInstance();

		// ݡͥȤμ
		$component = $container->_components[ $key ];

		// ϿƤʤХɤߤ
		if ( $component == NULL ){

			$component = $container->loadComponent( $key );

			if ( $component == NULL ){
				throw new ComponentNotRegisteredException( $key );
			}
		}

		// ݡͥ
		$component_config = $container->_component_configs[ $key ];

		// ϿƤʤ㳰
		if ( $component_config == NULL ){
			throw new ComponentNotRegisteredException( $key );
		}

		// ݡͥȥפ
		$scope = $component_config->getConfig( "scope" );

		// ϿƤʤ㳰
		if ( $scope == NULL ){
			throw new ComponentConfigException( $component_config->getConfigPath(), "scope", "mandatory" );
		}

		// ݡͥȤֵ
		switch ( $scope ){
		case ComponentScope::TRANSIENT:
			return clone $component;

		case ComponentScope::REQUEST:
			return $component;

		case ComponentScope::SESSION:
			return $component;
		}

		// scope˻ꤵ줿ɤ
		throw new ComponentConfigException( $component_config->getConfigPath(), "scope", "invalid key word:$scope" );

		return NULL;
	}

	/*
	 * ϿѤߥݡͥȤ˴sessionץݡͥȤϥåƤ¸
	 */
	public function destroyComponents(){

		Logger::writeln( LogLevel::INFO,  "DIƥΥݡͥȤ˴ޤ", __FILE__, __LINE__ );

		
		// 󥹥󥹤μ
		$container = & DIContainer::getInstance();

		// ݡͥȤμ
		$components = $container->_components;

		// ٤ƤΥݡͥȤ˴
		foreach( $components as $component_name => $component ){

			// ݡͥ
			$component_config = $container->_component_configs[ $component_name ];

			// ݡͥȥפ
			$scope = $component_config->getConfig( "scope" );

			// ݡͥȥפˤäƽʬ
			switch ( $scope ){
			case ComponentScope::TRANSIENT:
			case ComponentScope::REQUEST:
				// ʤˤ⤷ʤ
				break;

			case ComponentScope::SESSION:
				{
					// å˥󥹥󥹤򥻥å
					$_SESSION[ $component_name ] = serialize( $component );

					Logger::writeln( LogLevel::INFO,  "ݡͥ[$component_name]ϥå¸ޤ", __FILE__, __LINE__ );
				}
				break;
			}

		}

		Logger::writeln( LogLevel::INFO,  "DIƥΥݡͥȤ˴ޤ", __FILE__, __LINE__ );

	}

	/*
	 * 
	 */
	public function dump(){
		return $this->_components[ $key ];
	}

}

?>