<?php
/**
* ˴ؤ桼ƥƥ饹
*
* PHP version 5
*
* @package    core
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class ConfigUtil
{

	/*
	 * 롣ɬפ˱ƵͤκؤޥŸԤ
	 */
	public static function getConfig( $config_array, $key, $default_value, $process_macro ){

		// ͤ˥бֵͤ
		$value = $config_array[ $key ];
		if ( $value ){
			return $process_macro ? ConfigUtil::processMacro( $value ) : $value;
		}

		// ֵͤ
		return $process_macro ? ConfigUtil::processMacro( $default_value ) : $default_value;
	}

	/*
	 * ͤΥޥŸƵŪ˹Ԥ
	 */
	public static function processMacroRecursive( $value ){
		if ( is_array($value) ){
			// ξ
			foreach( $value as $child_key => $child_value ){
				$value[ $child_key ] = self::processMacroRecursive( $child_value );
			}
		}
		if ( is_string($value) ){
			// ʸξ
			$value = self::processMacro( $value );
		}
		return $value;
	}

	/*
	 * ͤΥޥŸԤ
	 */
	public static function processMacro( $value ){

		// ޥ
		$macro_defs = array(

				"%CONFIG_DIR%" => ResourceLocator::getPath( ResourcePath::CONFIG ),
				"%COMPONENTS_DIR%" => ResourceLocator::getPath( ResourcePath::COMPONENTS ),
				"%LOGS_DIR%" => ResourceLocator::getPath( ResourcePath::LOGS ),
				"%MODULES_DIR%" => ResourceLocator::getPath( ResourcePath::MODULES ),
				"%TEMPLATES_DIR%" => ResourceLocator::getPath( ResourcePath::TEMPLATES ),
				"%WEBAPP_DIR%" => WEBAPP_DIR . "/" . APPLICATION,

			);

		// ޥŸ
		foreach( $macro_defs as $macro_key => $macro_value ){
			$value = str_replace( $macro_key, $macro_value, $value );
		}

		// ֵ̤
		return $value;
	}

}

?>
