<?php
/**
*
* YAMLѡSpycˤˤʥå嵡ǽդ
*
* PHP version 5
*
* @package    configs
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once('Cache/Lite.php');

class CachedSpycConfig implements IConfig
{
	var $_config;
	var $_config_path;
	var $_cache;
	var $_config_file;

	/**
	 *    󥹥ȥ饯
	 *
	 * @access    public
	 */
	public function __construct()
	{
		$this->_config = array();
		$this->_config_path = "";
	}

	/**
	 * ̾
	 *
	 * @access    public
	 * @return    String
	 */
	public function getConfigName()
	{
		return "Spyc Config";
	}

	/**
	 *եѥ
	 *
	 * @access    public
	 * @return    String
	 */
	public function getConfigPath()
	{
		return $this->_config_path;
	}

	/**
	 *
	 *
	 * @access    public
	 * @param     config_path եեΥѥ
	 */
	public function create( $config_path )
	{
		$this->_config = array();
		$this->_config_path = $config_path;

		// åǥ쥯ȥ
		$cache_dir = ResourceLocator::getPath( ResourcePath::TEMP );

		// å奪ץ
		$options = array(
			'cacheDir' => "$cache_dir/",
			'lifeTime' => 999999999,
			'automaticSerialization' => TRUE
		);
		
		// å奪֥
		$this->_cache = new Cache_Lite($options);
	}

	/**
	 * 
	 *
	 * @access    public
	 * @param     config_config ե
	 */
	public function initConfig( $config_config ){
	}

	/**
	 *
	 *
	 * @access    public
	 * @param     config_file եΥѥ
	 */
	public function loadConfig( $config_file ){

		Logger::writeln( LogLevel::INFO,  "ե[$config_file]ɤ߹ߤޤ", __FILE__, __LINE__ );

//		$bench = new Benchmark();

		// å夬뤫
		$cache_data = $this->_cache->get($config_file);
		if ( $cache_data ){
			// Ф
			$config = $cache_data;
		}
		else{
			require_once('spyc.php');

			// Υ
			$config = Spyc::YAMLLoad($config_file);

			// ޥŸ
			$config = ConfigUtil::processMacroRecursive( $config );

			// å¸
			$ret = $this->_cache->save( $config, $config_file );
		}

		// ¸
		$this->_config = array_merge( $this->_config, $config );

//print System::arrayToString( $config );

//		$score = $bench->stop() * 1000;
//		print "loaded [$config_file] at $score msec.<BR>";

		Logger::writeln( LogLevel::INFO,  "ե[$config_file]ɤ߹ߤޤ", __FILE__, __LINE__ );

		$this->_config_file = $config_file;
	}

	/**
	 *쳬ؤΥ
	 *
	 * @access    public
	 * @return    Array 쳬ؤΥ
	 */
	public function getKeys()
	{
		return array_keys( $this->_config );
	}

	/**
	 * ͤ
	 *
	 * @access    public
	 * @param     String $key 
	 * @return    Array 쳬ؤΥ
	 */
	public function getConfig( $key )
	{
		return $this->_config[ $key ];
	}

	/*
	 *ͤ
	 */
	public function dump( $key = NULL )
	{
		$title = get_class($this) . "@" . $this->_config_file;
		if ( $key ){
			// ΥФͤ
			$value = $this->_config[ $key ];
			System::dumpVar( $value, $title );
		}
		else{
			// ٤Ƥͤ
			System::dumpArray( $this->_config, $title );
		}
	}
}
?>