<?php
/**
* ̥åȥݡͥ
*
* PHP version 5
*
* @package    components.db
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class ResultSetLogger implements IComponent
{
	var $_first_row;
	var $_column_size;
	var $_valid;
	var $_encoding;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_column_size = 20;
	}

	/*
	 * ݡͥ̾
	 */
	public function getComponentName(){
		return "ResultSetLogger Component";
	}

	/*
	 * 
	 */
	public function init(){
		$this->_first_row = TRUE;

		$this->_encoding = Profile::getGlobalConfig( "DB_CODE" );
	}

	/*
	 * ݡͥȤ
	 */
	public function initComponent( $component_config ){

		$this->_column_size = $component_config->getConfig( "column_size" );
		$this->_valid = ($component_config->getConfig( "valid" ) == 1) ? TRUE : FALSE;
	}

	/*
	 *	ԾʺǽιԤξϥإåˢ$rowϢ
	 */
	public function logRowInfoAssoc( $row ){

		// եDB_ROWLOGGERͭǤʤϲ⤷ʤ
		if ( !$this->_valid ){
			return;
		}

		// 󥳡ǥѴ
		$conv = new EncodingConverter(EncodingConverter::DB_TO_LOG);

		$col_size = $this->_column_size;
		$num_cols = count( $row );

		if ( $this->_first_row ){

			// ǽι
			$msg = "";
			foreach( $row as $key => $value ){
				$msg .= substr( $key . str_repeat(" ",$col_size), 0, $col_size );
			}
			Logger::writeln( LogLevel::SQL, $msg, __FILE__, __LINE__ );

			// 
			$msg = str_repeat( str_repeat("-",$col_size), $num_cols );
			Logger::writeln( LogLevel::SQL, $msg, __FILE__, __LINE__  );

			$this->_first_row = FALSE;
		}

		// Ծ
		$msg = "";
		foreach( $row as $key => $value ){
			$value .= str_repeat( " ", $col_size );
			$msg .= mb_strimwidth ( $value, 0, $col_size, " ", "UTF-8" );
		}
		Logger::writeln( LogLevel::SQL, $msg, __FILE__, __LINE__, $conv );
	}
}

?>
