<?php

/**
* ǡȥݡͥ
*
* PHP version 5
*
* @package    components.db
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
require_once( 'DataGatewayException.class.php');
require_once( 'TableNameMappingException.class.php');

class DataGateway implements IComponent
{
	const UPDATE_FIELD_NONE		= 1;		// եɤ򹹿ʤ
	const UPDATE_FIELD_VALUE	= 2;		// եɤͤǹ
	const UPDATE_FIELD_NOW		= 3;		// եɤ򸽺߻ǹ
	const UPDATE_FIELD_FUNC		= 4;		// եɤؿǹ

	var $_tablename_map;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_tablename_map = array();
	}


	/*
	 * ݡͥ̾
	 */
	public function getComponentName(){
		return "DataGateway Component";
	}

	/*
	 * ݡͥȤ
	 */
	public function initComponent( $component_config ){

		// DTO_TABLENAME_MAPPINGɤ߹
		$this->_tablename_map = $component_config->getConfig("dto_table_mapping");

	}


	/*
	 * ԥǡ饪֥
	 */
	private  function rowToObject( $row, $dto_object ){

		if ( !$dto_object ){
			return NULL;
		}

		$o = clone $dto_object;

		$class_vars = get_class_vars(get_class($dto_object));

		foreach ($class_vars as $name => $value) {
			// DTOΥץѥƥ˥å
			$o->$name = $row[$name];
		}

		return $o;
	}

	/*
	 *	SQL(SELECT)
	 */
	private  function buildSelectSQL( $table, $where_clause, $order_by, $limit, $offset )
	{
		$sql = "select * from $table";

		if ( $where_clause != NULL ){
			$sql .= " where " . $where_clause;
		}

		if ( $order_by != NULL ){
			$sql .= " order by " . $order_by;
		}

		if ( $limit != NULL ){
			$sql .= " limit " . $limit;
		}

		if ( $offset != NULL ){
			$sql .= " offset " . $offset;
		}
	
		return $sql;
	}

	/*
	 *	SQL(UPDATE)
	 */
	private  function buildUpdateSQL( $table, $dto_object, $update_fields, $default_update, &$params )
	{
		$object_vars = get_object_vars($dto_object);

		$set = NULL;
		foreach ($object_vars as $name => $value) {
			// IDϹʤ
			if ( strcmp($name,"id") == 0 ){
				continue;
			}
			// ˡ
			$update_field = $update_fields[ $name ];
			// ˡˤäʬ
			if ( $update_field == NULL ){
				// ǥեȤιˡ
				$update_method = $default_update;
			}
			else if ( is_string($update_field) ){
				// ؿǹ
				$update_method = self::UPDATE_FIELD_FUNC;
				$func = $update_field;
			}
			else if ( is_int($update_field) ){
				// ˡ
				$update_method = $update_field;
			}
			else{
				// 顼
				$update_method = -1;
			}
			// ˡˤäʬ
			switch ( $update_method ){
			case self::UPDATE_FIELD_NONE:
				break;
			case self::UPDATE_FIELD_VALUE:
				{
					// 
					if ( $set != NULL ){
						$set .= ",";
					}
					// set X=Y
					$set .= "$name = ?";
					// ѥ᡼ɲ
					array_push( $params, $value );
				}
				break;
			case self::UPDATE_FIELD_NOW:
				{
					// 
					if ( $set != NULL ){
						$set .= ",";
					}
					// set X=NOW()
					$set .= "$name = NOW()";
				}
				break;
			case self::UPDATE_FIELD_FUNC:
				{
					// 
					if ( $set != NULL ){
						$set .= ",";
					}
					// set X=func
					$set .= "$name = $func";
				}
				break;
			}
		}

		$sql = "update $table set $set where id = ?";

		array_push( $params, $object_vars["id"] );

		return $sql;
	}

	/*
	 *	SQL(INSERT)
	 */
	private  function buildInsertSQL( $table, $dto_object, $update_fields, $default_update, &$params )
	{
		$object_vars = get_object_vars($dto_object);
//		$object_vars = get_class_vars( get_class($dto_object) );

//print "class:" . get_class($dto_object) . "<BR>";
//print "vars:" . count($object_vars) . "<BR>";

		$field_list = NULL;
		$value_list = NULL;

		foreach ($object_vars as $name => $value) {

//print "[$name]=$value<BR>";

			// IDϹʤ
			if ( strcmp($name,"id") == 0 ){
				continue;
			}
			// ˡ
			$update_field = $update_fields[ $name ];
			// ˡˤäʬ
			if ( $update_field == NULL ){
				// ǥեȤιˡ
				$update_method = $default_update;
			}
			else if ( is_string($update_field) ){
				// ؿǹ
				$update_method = self::UPDATE_FIELD_FUNC;
				$func = $update_field;
			}
			else if ( is_int($update_field) ){
				// ˡ
				$update_method = $update_field;
			}
			else{
				// 顼
				$update_method = -1;
			}
//print "name:$name update:$update_method<BR>";
			// ˡˤäʬ
			switch ( $update_method ){
			case self::UPDATE_FIELD_NONE:
				break;
			case self::UPDATE_FIELD_VALUE:
				{
					// եɥꥹ
					if ( $field_list != NULL ){
						$field_list .= ",";
					}
					$field_list .= $name;
					// ͥꥹ
					if ( $value_list != NULL ){
						$value_list .= ",";
					}
					$value_list .= "?";
					// ѥ᡼ɲ
					array_push( $params, $value );
				}
				break;
			case self::UPDATE_FIELD_NOW:
				{
					// եɥꥹ
					if ( $field_list != NULL ){
						$field_list .= ",";
					}
					$field_list .= $name;
					// ͥꥹ
					if ( $value_list != NULL ){
						$value_list .= ",";
					}
					$value_list .= "NOW()";
				}
				break;
			case self::UPDATE_FIELD_FUNC:
				{
					// եɥꥹ
					if ( $field_list != NULL ){
						$field_list .= ",";
					}
					$field_list .= $name;
					// ͥꥹ
					if ( $value_list != NULL ){
						$value_list .= ",";
					}
					$value_list .= $func;
				}
				break;
			}
		}

		$sql = "insert into $table($field_list) values($value_list)";

//print "SQL:$sql<BR>";

		return $sql;
	}

	/*
	 *	¸
	 */
	public  function save( $dto_object, $auto_reload = TRUE, $update_fields = array(), $default_update = self::UPDATE_FIELD_NONE )
	{
		try{
			$params = array();

			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto_object );

			// IDͿƤUPDATEͿƤʤINSERT¹Ԥ
			$is_new = ($dto_object->id == NULL);

			// SQL
			if ( $is_new ){
				$sql = $this->buildInsertSQL( $table, $dto_object, $update_fields, $default_update, $params );
			}
			else{
				$sql = $this->buildUpdateSQL( $table, $dto_object, $update_fields, $default_update, $params );
			}

			// SQL¹
			$this->execute( $sql, $params );

			// ޤɲä֥Ȥ
			if ( !$auto_reload ){
				// ưɤʤϤޤ
				return NULL;
			}

			if ( $is_new ){

				// ƥʤDataSourceݡͥȤ
				$data_source = DIContainer::getComponent( "db:DataSource" );

				$id = $data_source->getLastInsertId();
			}
			else{
				$id = $dto_object->id;
			}
			
			return $this->findByID($dto_object, $id);
		}
		catch ( Exception $e ){
			throw new DataGatewayException( "DataGateway#save failed", $e );
		}
	}

	/*
	 *	SQL¹(INSERT/DELETE/UPDATE)
	 */
	public  function execute( $sql, $params = NULL )
	{
		// ƥʤDataSourceݡͥȤ
		$data_source = DIContainer::getComponent( "db:DataSource" );

		try{

			// ¹
			$result = $data_source->prepareExecute( $sql, $params, __FILE__, __LINE__ );

		}
		catch ( Exception $e ) {

			// ̤throw
			throw new DataGatewayException( "exec_SQL failed", $e );
		}

		return $result;
	}

	/*
	 *	SQL¹(SELECT)
	 */
	public  function query( $sql, $params = NULL )
	{
		// ƥʤDataSourceݡͥȤ
		$data_source = DIContainer::getComponent( "db:DataSource" );

		$a = array();

		try{

			// ¹
			$result = $data_source->prepareExecute( $sql, $params, __FILE__, __LINE__ );

			// եå
			while( $row = $data_source->fetchAssoc( $result ) ){
				$a[] = $row;
			}
		}
		catch ( Exception $e ) {

			// ̤throw
			throw new DataGatewayException( "exec_SQL failed", $e );
		}

		return $a;
	}

	/*
	 *	SQL
	 */
	public  function findBySQL( $dto_object, $sql, $params = NULL, $order_by = NULL, $limit = NULL, $offset = NULL ) 
	{
		if ( $params && !is_array($params) ){
			throw new ParameterException( "params", gettype($params), "must be an array" );
		}

		$a = array();

		// DataSourceݡͥȤ
		$data_source = DIContainer::getComponent( "db:DataSource" );

		// ƥʤResultSetLoggerݡͥȤ
		$row_logger = DIContainer::getComponent( "db:ResultSetLogger" );
		$row_logger->init();

		try{

			// ¹
			$result = $data_source->prepareExecute( $sql, $params, __FILE__, __LINE__ );

			// եå
			while( $row = $data_source->fetchAssoc( $result ) ){
				$o = $this->rowToObject( $row, $dto_object );
				$row_logger->logRowInfoAssoc( $row );
				if ( $o ){
					array_push( $a, $o );
				}
			}
		}
		catch ( Exception $e ) {

print $e->getMessage() . "<BR>";

			// ̤throw
			throw new DataAccessException( $sql, $params, "findBySQL failed", $e );
		}

		return $a;
	}

	/*
	 *	ĤΥեɤΤߤǸ
	 */
	public  function findBy( $dto_object, $field, $value, $order_by = NULL, $limit = NULL, $offset = NULL )
	{
		$where_clause = "$field = ?";
		$params = array( $value );

		$a = $this->findAll( $dto_object, $where_clause, $params, $order_by, $limit, $offset );

		return $a;
	}

	/*
	 *	ID鸡
	 */
	public  function findByID( $dto_object, $id ) 
	{
		// idNULLʤ鲿֤ʤ
		if ( $id == NULL ){
			return array();
		}

		if ( is_string($id) || is_int($id) || is_numeric($id) ){
			// Ĥꤷ
			$where_clause = "id = ?";
			$params = array( $id );

			$a = $this->findAll( $dto_object, $where_clause, $params );

			return array_shift($a);
		}
		else if( is_array($id) ){
			// ʣĻꤷ
			$where = array();
			$params = array();
			
			foreach( $id as $i ){
				$where[] = "?";
				$params[] = $i;
			}

			$where_clause = "id in (" . implode(",",$where) . ")";

			$a = $this->findAll( $dto_object, $where_clause, $params );

			return $a;
		}
		else{
			throw new ParameterException( "id", $id );
		}
	}

	/*
	 *	
	 */
	public  function destroyById( $dto_object, $id ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto_object );

			// idNULLʤ㳰
			if ( $id == NULL ){
				throw new ParameterException( "id:", "NULL" );
			}

			if ( is_string($id) || is_int($id) || is_numeric($id) ){
				// Ĥꤷ
				$sql = "delete from $table where id = ?";
				$params = array( $id );
			}
			else if( is_array($id) ){
				// ʣĻꤷ
				$where = array();
				$params = array();
				
				foreach( $id as $i ){
					$where[] = "?";
					$params[] = $i;
				}

				$sql = "delete from $table where id in (" . implode(",",$where) . ")";
			}
			else{
				throw new ParameterException( "id", $id );
			}

			$this->execute( $sql, $params );
		}
		catch ( Exception $e ){
			throw new DataGatewayException( "DataGateway#destroyById failed", $e );
		}
	}

	/*
	 *	ĤΥեɤ˹פ쥳ɤ
	 */
	public  function destroyBy( $dto_object, $field, $value )
	{
		$where_clause = "$field = ?";
		$params = array( $value );

		$this->destroyAll( $dto_object, $where_clause, $params );
	}


	/*
	 *	˹פ쥳ɤ
	 */
	public  function destroyAll( $dto_object, $where_clause = NULL, $params = NULL ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto_object );

			$sql = "delete from $table where $where_clause";

			$this->execute( $sql, $params );
		}
		catch ( Exception $e ){
			throw new DataGatewayException( "DataGateway#destroyAll failed", $e );
		}
	}

	/*
	 *	ơ֥Ͽ쥳ɿ
	 */
	public  function count( $dto_object, $where_clause = NULL, $params = NULL ) 
	{
		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto_object );

			// SQL
			$sql = "select count(*) from $table";
			if ( $where_clause ){
				$sql .= " where $where_clause";
			}

			// SQL¹
			$result = $this->execute( $sql, $params );

			// ƥʤDataSourceݡͥȤ
			$data_source = DIContainer::getComponent( "db:DataSource" );

			// եå
			$row = $data_source->fetchArray( $result );

			return $row[0];
		}
		catch ( Exception $e ){
			throw new DataGatewayException( "DataGateway#count failed", $e );
		}
	}

	/*
	 *	ǽΣ
	 */
	public  function findFirst( $dto_object, $where_clause = NULL, $params = NULL, $order_by = NULL ) 
	{
		$a = $this->findAll( $dto_object, $where_clause, $params, $order_by, 1, NULL );

		return array_shift($a);
	}


	/*
	 *	
	 */
	public  function findAll( $dto_object, $where_clause = NULL, $params = NULL, $order_by = NULL, $limit = NULL, $offset = NULL ) 
	{
		if ( $params && !is_array($params) ){
			throw new ParameterException( "params", gettype($params), "must be an array" );
		}

		try{
			// ơ֥̾
			$table = self::getTableNameFromDTO( $dto_object );

			// SQLκ
			$sql = $this->buildSelectSQL( $table, $where_clause, $order_by, $limit, $offset, $conv );

			return $this->findBySQL( $dto_object, $sql, $params, $order_by, $limit, $offset );
		}
		catch ( Exception $e ){
			throw new DataGatewayException( "DataGateway#findAll failed", $e );
		}
	}

	/*
	 *	DTOơ֥̾
	 */
	public  function getTableNameFromDTO( $dto_object ) 
	{
		if ( $dto_object == NULL ){
			throw new NullPointerException( "dto_object" );
		}
		if ( !is_object($dto_object) ){
			throw new NonObjectException( $dto_object, "DTO" );
		}

		$dto_class = get_class($dto_object);
		$table = $this->_tablename_map[ $dto_class ];

		if ( $table == NULL ){
			throw new TableNameMappingException( $dto_class );
		}

		return $table;
	}

}

?>