<?
/**
* ڡ㥳ݡͥ
*
* PHP version 5
*
* @package    components.charcoal
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

require_once( 'PageInfo.class.php' );

class CharcoalPager implements IComponent
{
	var $_config;

	/*
	 * 󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_config = NULL;
	}

	/*
	 * ݡͥ̾
	 */
	public function getComponentName(){
		return "Pager Component";
	}

	/*
	 * ݡͥȤ
	 */
	public function initComponent( $component_config ){

		// page_settings
		$page_settings = $component_config->getConfig("page_settings");

		$this->_config = $page_settings;

	}

	/*
	 * ڡֵ
	 */
	public function getPageInfo( $list_name, Request $request, $total_rows ){

		// ߤΥڡ
		$page = intval($request->get( "page" ));
		if ( $page == NULL || !is_int($page) || $page <= 0 ){
			$page = 1;
		}

		// ꥹ̾˰פ
		$config = $this->_config[ $list_name ];

		// ڡɽԿ
		$rows_per_page = $config[ "rows_per_page" ];
		if ( $rows_per_page == NULL || !is_int($rows_per_page) || $rows_per_page <= 0 ){
			$rows_per_page = 10;
		}

		// ١URL
		$base_url = $request->getURL();

//print "base_url:$base_url<BR>";

		// ڡ
		$page_info = new PageInfo( $total_rows, $page, $rows_per_page, $base_url );

		return $page_info;
	}


	/*
	 * ڡ󤫤ڡʥӥ
	 */
	public function makePageNavigator( PageInfo $page_info ){

		$navi = "";

		// ߤΥڡ
		$page = $page_info->getPage();

		// Կ
		$total_rows = $page_info->getTotalRows();

		// ڡɽԿ
		$rows_per_page = $page_info->getRowsPerPage();

		// ١URL
		$base_url = $page_info->getBaseURL();

		// Ƭڡ
		$url = $base_url->setParameter( "page", 1 )->makeURLString();
		$navi .= "<a href=\"$url\">|&lt;</a>";

		// Υڡ
		if ( $page > 1 ){
			$url = $base_url->setParameter( "page", $page - 1 )->makeURLString();
			$navi .= "&nbsp;&nbsp;<a href=\"$url\">&lt;-</a>";
		}
		else{
			$navi .= "&nbsp;&nbsp;&lt;-";
		}

		// ڡ
		$total_page = intval($total_rows / $rows_per_page) + 1;

		// ڡʬ֤
		for( $i=1; $i<=$total_page; $i++ ){
			if ( $i == $page ){
				$navi .= "&nbsp;&nbsp;[$i]";
			}
			else{
				$url = $base_url->setParameter( "page", $i )->makeURLString();
				$navi .= "&nbsp;&nbsp;<a href=\"$url\">[$i]</a>";
			}
		}

		// Υڡ
		if ( $page< $total_page ){
			$url = $base_url->setParameter( "page", $page + 1 )->makeURLString();
			$navi .= "&nbsp;&nbsp;<a href=\"$url\">-&gt;</a>";
		}
		else{
			$navi .= "&nbsp;&nbsp;-&gt;";
		}

		// ǸΥڡ
		$url = $base_url->setParameter( "page", $total_page )->makeURLString();
		$navi .= "&nbsp;&nbsp;<a href=\"$url\">&gt;|</a>";

		return $navi;
	}
}


?>
