<?php
/**
* ѥ󤯤ꥹȥݡͥ
*
* PHP version 5
*
* @package    components.charcoal
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class BreadcrumbList implements IComponent
{
	var $_breadcrumbs;
	var $_format;
	var $_separator;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_breadcrumbs = array();
	}

	/*
	 * ݡͥ̾
	 */
	public function getComponentName(){
		return "BreadcrumbList Component";
	}

	/*
	 * ݡͥȤ
	 */
	public function initComponent( $component_config ){

		$this->_breadcrumbs = $component_config->getConfig( "breadcrumbs" );
		$this->_format 		= $component_config->getConfig( "format" );
		$this->_separator 	= $component_config->getConfig( "separator" );

	}

	/*
	 * ѥ󤯤ꥹȤ
	 */
	public function makeList( $breadcrumbs ){

		// NULLå
		if ( !$breadcrumbs ){
			throw new NullPointerException( "breadcrumbs" );
		}

		// å
		if ( !is_array($breadcrumbs) ){
			throw new ParameterException( "breadcrumbs", $breadcrumbs, "not array" );
		}

		// LinkerݡͥȤ
		$linker = DIContainer::getComponent( "charcoal:Linker" );

		// ѥ󤯤
		$out = "";

		foreach( $breadcrumbs as $b ){
			// ѥ󤯤
			$setting = $this->_breadcrumbs[ $b ];
			// ꤬
			if ( $setting ){
				// ץ̾
				$caption = $setting[ 'caption' ];
				$link_name = $setting[ 'link' ];

				// LinkerݡͥȤʪɥ쥹Ѵ
				$url = $linker->getLink( $link_name );

				// ޥŸ
				$str = $this->_format;
				$str = str_replace( "%CAPTION%", $caption, $str );
				$str = str_replace( "%URL%", $url, $str );

				// ɲ
				if ( strlen($out) > 0 ){
					$out .= $this->_separator;
				}
				$out .= $str;
			}
		}

		return $out;
	}


}

?>
