/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.scrollablemenu;

import charactermanaj.ui.scrollablemenu.JScrollerMenuItem;
import charactermanaj.ui.scrollablemenu.ScrollableMenuEvent;
import charactermanaj.ui.scrollablemenu.ScrollableMenuEventListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class JScrollableMenu
extends JMenu {
    private static final long serialVersionUID = -5174737355715398136L;
    public static final int DEFAULT_REPEAT_DELAY = 200;
    public static final int DEFAULT_FAST_REPEAT_DELAY = 80;
    public static final int DEFAULT_MAX_VISIBLE = 10;
    public static final int DEFAULT_REPEAT_THRESHOLD = 3;
    private int _startPos;
    private int _offset;
    private ArrayList<JMenuItem> _menus = new ArrayList();
    private Timer _timer;
    private int _scrollCount;
    private JScrollerMenuItem _upButton;
    private JScrollerMenuItem _downButton;
    private int _delay = 200;
    private int _delayFast = 80;
    private int _repeat_threshold = 3;
    private Boolean _directionUp;
    private int maxVisible = 10;

    public JScrollableMenu() {
        this("");
    }

    public JScrollableMenu(String name) {
        super(name);
        this.initScrollableMenu();
    }

    private void initScrollableMenu() {
        this._timer = new Timer(this._delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollableMenu.this.doScroll();
                JScrollableMenu.this._scrollCount++;
                if (JScrollableMenu.this._scrollCount >= JScrollableMenu.this._repeat_threshold) {
                    ((Timer)e.getSource()).setDelay(JScrollableMenu.this._delayFast);
                }
            }
        });
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
                JScrollableMenu.this._timer.stop();
                JScrollableMenu.this._directionUp = null;
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                JScrollableMenu.this._timer.stop();
                JScrollableMenu.this._directionUp = null;
            }

            @Override
            public void menuSelected(MenuEvent e) {
            }
        });
    }

    public void initScroller() {
        if (this._upButton != null || this._downButton != null) {
            this.removeAllScrollableItems();
            return;
        }
        Class<JScrollableMenu> cls = JScrollableMenu.class;
        URL downPngURL = cls.getResource("arrow-down.png");
        URL upPngURL = cls.getResource("arrow-up.png");
        if (downPngURL == null || upPngURL == null) {
            throw new RuntimeException("png resource not found.");
        }
        ImageIcon iconDown = new ImageIcon(downPngURL);
        ImageIcon iconUp = new ImageIcon(upPngURL);
        this._upButton = new JScrollerMenuItem(iconUp);
        this._downButton = new JScrollerMenuItem(iconDown);
        ScrollableMenuEventListener sc = new ScrollableMenuEventListener(){

            @Override
            public void start(ScrollableMenuEvent e) {
                Boolean direction = e.getSource().equals(JScrollableMenu.this._upButton) ? Boolean.TRUE : Boolean.FALSE;
                JScrollableMenu.this.doScroll(direction);
                JScrollableMenu.this._scrollCount = 0;
                JScrollableMenu.this._timer.setDelay(JScrollableMenu.this._delay);
                JScrollableMenu.this._timer.start();
            }

            @Override
            public void end(ScrollableMenuEvent e) {
                JScrollableMenu.this._timer.stop();
                JScrollableMenu.this._directionUp = null;
            }
        };
        this._upButton.addScrollableMenuEventListener(sc);
        this._downButton.addScrollableMenuEventListener(sc);
        this.add(this._upButton);
        this._startPos = this.getItemCount();
        this.add(this._downButton);
        if (JScrollableMenu.isScreenMenu()) {
            this._upButton.setVisible(false);
            this._downButton.setVisible(false);
        }
    }

    public void doScroll(Boolean direction) {
        this._directionUp = direction;
        this.doScroll();
    }

    protected void doScroll() {
        if (this._directionUp != null) {
            if (this._directionUp.booleanValue()) {
                this.scrollDown();
            } else {
                this.scrollUp();
            }
        }
    }

    public static boolean isScreenMenu() {
        String macScreenMenu = System.getProperty("apple.laf.useScreenMenuBar");
        return macScreenMenu != null && macScreenMenu.toLowerCase().equals("true");
    }

    public void setMaxVisible(int maxVisible) {
        this.maxVisible = maxVisible;
    }

    public int getMaxVisible() {
        return this.maxVisible;
    }

    public void adjustMaxVisible(int height) {
        int numOfItems = 0;
        if (this._menus.size() > 0) {
            int heightPerItem = this._menus.get((int)0).getPreferredSize().height;
            if (heightPerItem <= 0) {
                return;
            }
            numOfItems = height / heightPerItem;
        }
        if ((numOfItems -= this._startPos + 1 + 2) < 0) {
            numOfItems = 1;
        }
        this.maxVisible = numOfItems;
        this.updateScrollableMenus();
    }

    public int getRepeatDelay() {
        return this._delay;
    }

    public int getRepeatDelayFast() {
        return this._delayFast;
    }

    public void setRepeatDelay(int delay) {
        this._delay = delay;
    }

    public void setRepeatDelayFast(int delayFast) {
        this._delayFast = delayFast;
    }

    public void setScrollableItems(Collection<? extends JMenuItem> menus) {
        if (this._upButton == null || this._downButton == null) {
            throw new IllegalStateException("initScroller\u3092\u5148\u306b\u547c\u3073\u51fa\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        this.removeAllScrollableItems();
        if (menus != null) {
            for (JMenuItem jMenuItem : menus) {
                int idx = this._startPos + this._menus.size();
                this.add((Component)jMenuItem, idx);
                this._menus.add(jMenuItem);
            }
        }
        this.updateScrollableMenus();
    }

    public void removeAllScrollableItems() {
        for (JMenuItem item : this._menus) {
            this.remove(item);
        }
        this._menus.clear();
        this._offset = 0;
    }

    public void updateScrollableMenus() {
        boolean screenMenu = JScrollableMenu.isScreenMenu();
        int numOfItems = this._menus.size();
        for (int idx = 0; idx < numOfItems; ++idx) {
            boolean visible = false;
            if (idx >= this._offset && idx < this._offset + this.maxVisible || screenMenu) {
                visible = true;
            }
            this._menus.get(idx).setVisible(visible);
        }
    }

    public int getOffset() {
        return this._offset;
    }

    public void scrollUp() {
        int numOfItems = this._menus.size();
        int limit = numOfItems - this.maxVisible;
        if (limit < 0) {
            limit = 0;
        }
        ++this._offset;
        if (this._offset >= limit) {
            this._offset = limit;
            this._timer.stop();
            this._directionUp = null;
        }
        this.updateScrollableMenus();
    }

    public void scrollDown() {
        --this._offset;
        if (this._offset < 0) {
            this._offset = 0;
            this._timer.stop();
            this._directionUp = null;
        }
        this.updateScrollableMenus();
    }
}

