/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class PartsRandomChooserDialog
extends JDialog {
    private static final long serialVersionUID = -8427874726724107481L;
    protected static final String STRINGS_RESOURCE = "languages/partsrandomchooserdialog";
    private Box centerPnl;
    private CharacterData characterData;
    private PartsSetSynchronizer partsSync;
    private Action actRandomAll;
    private Action actBack;
    private Action actCancel;
    private LinkedList<Map<RandomChooserPanel, PartsIdentifier>> history = new LinkedList();
    private int maxHistory;
    private final AtomicInteger eventLock = new AtomicInteger(0);

    public PartsRandomChooserDialog(JFrame parent, CharacterData characterData, PartsSetSynchronizer partsSync) {
        super((Frame)parent, false);
        try {
            if (characterData == null || partsSync == null) {
                throw new IllegalArgumentException();
            }
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PartsRandomChooserDialog.this.onClose();
                }
            });
            this.characterData = characterData;
            this.partsSync = partsSync;
            AppConfig appConfig = AppConfig.getInstance();
            this.maxHistory = appConfig.getRandomChooserMaxHistory();
            if (this.maxHistory < 0) {
                this.maxHistory = 0;
            }
            this.initLayout();
            this.pack();
            this.setLocationRelativeTo(parent);
        }
        catch (RuntimeException ex) {
            this.dispose();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLayout() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("partsRandomChooser"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.centerPnl = Box.createVerticalBox();
        ActionListener changePartsIdentifierListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PartsRandomChooserDialog.this.eventLock.get() == 0) {
                    PartsRandomChooserDialog.this.onChangePartsIdentifiers();
                }
            }
        };
        PartsSet partsSet = this.partsSync.getCurrentPartsSet();
        this.eventLock.incrementAndGet();
        try {
            for (PartsCategory category : this.characterData.getPartsCategories()) {
                List partsIdentifiers = (List)partsSet.get(category);
                int partsLen = partsIdentifiers != null ? partsIdentifiers.size() : 0;
                boolean enable = true;
                if (partsLen < 1) {
                    partsLen = 1;
                    enable = false;
                }
                for (int partsIdx = 0; partsIdx < partsLen; ++partsIdx) {
                    PartsIdentifier partsIdentifier = null;
                    if (partsIdentifiers != null && partsIdx < partsIdentifiers.size()) {
                        partsIdentifier = (PartsIdentifier)partsIdentifiers.get(partsIdx);
                    }
                    boolean lastInCategory = partsIdx == partsLen - 1;
                    int idx = this.centerPnl.getComponentCount();
                    RandomChooserPanel pnl = this.addPartsChooserPanel(this.centerPnl, idx, category, lastInCategory, changePartsIdentifierListener);
                    pnl.setEnableRandom(enable && !category.isMultipleSelectable());
                    if (partsIdentifier == null) continue;
                    pnl.setSelectedPartsIdentifier(partsIdentifier);
                }
            }
        }
        finally {
            this.eventLock.decrementAndGet();
        }
        JScrollPane scr = new JScrollPane(this.centerPnl){
            private static final long serialVersionUID = 1L;

            @Override
            public JScrollBar createVerticalScrollBar() {
                JScrollBar sb = super.createVerticalScrollBar();
                sb.setUnitIncrement(12);
                return sb;
            }
        };
        scr.setVerticalScrollBarPolicy(22);
        contentPane.add((Component)scr, "Center");
        this.actRandomAll = new AbstractAction(strings.getProperty("randomAll")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PartsRandomChooserDialog.this.onRandomAll();
            }
        };
        this.actBack = new AbstractAction(strings.getProperty("back")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PartsRandomChooserDialog.this.onBack();
            }
        };
        this.actCancel = new AbstractAction(strings.getProperty("close")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PartsRandomChooserDialog.this.onClose();
            }
        };
        JButton btnClose = new JButton(this.actCancel);
        JButton btnRandomAll = new JButton(this.actRandomAll);
        JButton btnBack = new JButton(this.actBack);
        Box btnPanel = Box.createHorizontalBox();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 42));
        btnPanel.add(btnRandomAll);
        btnPanel.add(btnBack);
        btnPanel.add(Box.createHorizontalGlue());
        btnPanel.add(btnClose);
        contentPane.add((Component)btnPanel, "South");
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(btnRandomAll);
        Toolkit tk = Toolkit.getDefaultToolkit();
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeDialog");
        am.put("closeDialog", this.actCancel);
        this.addHistory(this.getSelection());
        this.updateUIState();
    }

    protected void updateUIState() {
        this.actBack.setEnabled(this.history.size() > 1);
    }

    protected void onClose() {
        this.dispose();
    }

    protected List<RandomChooserPanel> getRandomChooserPanels() {
        ArrayList<RandomChooserPanel> panels = new ArrayList<RandomChooserPanel>();
        int mx = this.centerPnl.getComponentCount();
        for (int idx = 0; idx < mx; ++idx) {
            Component comp = this.centerPnl.getComponent(idx);
            if (!(comp instanceof RandomChooserPanel)) continue;
            RandomChooserPanel pnl = (RandomChooserPanel)comp;
            panels.add(pnl);
        }
        return panels;
    }

    protected Map<RandomChooserPanel, PartsIdentifier> getSelection() {
        HashMap<RandomChooserPanel, PartsIdentifier> selection = new HashMap<RandomChooserPanel, PartsIdentifier>();
        for (RandomChooserPanel pnl : this.getRandomChooserPanels()) {
            PartsIdentifier partsIdentifier = pnl.getSelectedPartsIdentifier();
            selection.put(pnl, partsIdentifier);
        }
        return selection;
    }

    protected void addHistory(Map<RandomChooserPanel, PartsIdentifier> selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        this.history.addLast(selection);
        while (this.history.size() > this.maxHistory) {
            this.history.removeFirst();
        }
        this.updateUIState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onBack() {
        if (this.history.size() <= 1) {
            return;
        }
        this.history.removeLast();
        Map<RandomChooserPanel, PartsIdentifier> selection = this.history.getLast();
        this.eventLock.incrementAndGet();
        try {
            for (Map.Entry<RandomChooserPanel, PartsIdentifier> entry : selection.entrySet()) {
                RandomChooserPanel pnl = entry.getKey();
                PartsIdentifier partsIdentifier = entry.getValue();
                pnl.setSelectedPartsIdentifier(partsIdentifier);
            }
            PartsSet partsSet = this.makePartsSet(selection.values());
            if (!partsSet.isEmpty()) {
                this.partsSync.setPartsSet(partsSet);
            }
        }
        finally {
            this.eventLock.decrementAndGet();
        }
        this.updateUIState();
    }

    protected void onRandomAll() {
        this.eventLock.incrementAndGet();
        try {
            for (RandomChooserPanel pnl : this.getRandomChooserPanels()) {
                if (!pnl.isEnableRandom()) continue;
                pnl.selectRandom();
            }
            this.onChangePartsIdentifiers();
        }
        finally {
            this.eventLock.decrementAndGet();
        }
    }

    protected PartsSet makePartsSet(Collection<PartsIdentifier> selection) {
        PartsSet partsSet = new PartsSet();
        for (PartsIdentifier partsIdentifier : selection) {
            if (partsIdentifier == null) continue;
            PartsCategory category = partsIdentifier.getPartsCategory();
            partsSet.appendParts(category, partsIdentifier, null);
        }
        return partsSet;
    }

    protected void onChangePartsIdentifiers() {
        Map<RandomChooserPanel, PartsIdentifier> selection = this.getSelection();
        PartsSet partsSet = this.makePartsSet(selection.values());
        if (!partsSet.isEmpty()) {
            this.partsSync.setPartsSet(partsSet);
            this.addHistory(selection);
        }
    }

    protected RandomChooserPanel addPartsChooserPanel(final Box centerPnl, int addPos, final PartsCategory category, final boolean lastInCategory, final ActionListener changePartsIdentifierListener) {
        RandomChooserPanel pnl = new RandomChooserPanel(category, lastInCategory){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onClickAdd(ActionEvent e) {
                int mx = centerPnl.getComponentCount();
                for (int idx = 0; idx < mx; ++idx) {
                    Component comp = centerPnl.getComponent(idx);
                    if (!comp.equals(this)) continue;
                    PartsRandomChooserDialog.this.addPartsChooserPanel(centerPnl, idx + 1, category, lastInCategory, changePartsIdentifierListener);
                    centerPnl.validate();
                    ((JButton)e.getSource()).setVisible(false);
                    break;
                }
            }
        };
        pnl.addActionListener(changePartsIdentifierListener);
        centerPnl.add((Component)pnl, addPos);
        return pnl;
    }

    protected class RandomChooserPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private EventListenerList listeners = new EventListenerList();
        private JCheckBox label;
        private JComboBox partsCombo;
        private JToggleButton btnReject;

        public RandomChooserPanel(PartsCategory category, boolean lastInCategory) {
            Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(PartsRandomChooserDialog.STRINGS_RESOURCE);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3))));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 13;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            String categoryName = category.getLocalizedCategoryName();
            this.label = new JCheckBox(categoryName, true);
            this.add((Component)this.label, gbc);
            JButton btnRandom = new JButton(new AbstractAction(strings.getProperty("random")){
                private static final long serialVersionUID = -1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RandomChooserPanel.this.onClickRandom(e);
                }
            });
            gbc.gridx = 1;
            gbc.weightx = 0.0;
            this.add((Component)btnRandom, gbc);
            ArrayList<PartsIdentifier> partsList = new ArrayList<PartsIdentifier>();
            partsList.addAll(PartsRandomChooserDialog.this.characterData.getPartsSpecMap(category).keySet());
            Collections.sort(partsList);
            if (category.isMultipleSelectable()) {
                partsList.add(0, null);
            }
            this.partsCombo = new JComboBox<PartsIdentifier>(partsList.toArray(new PartsIdentifier[partsList.size()]));
            this.partsCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RandomChooserPanel.this.onSelectChangePartsIdentifier(e);
                }
            });
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            this.add((Component)this.partsCombo, gbc);
            this.btnReject = new JToggleButton(new AbstractAction(strings.getProperty("reject")){
                private static final long serialVersionUID = -1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    RandomChooserPanel.this.onClickReject(e);
                }
            });
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            this.add((Component)this.btnReject, gbc);
            if (category.isMultipleSelectable() && lastInCategory) {
                JButton btnAdd = new JButton(new AbstractAction(strings.getProperty("add")){
                    private static final long serialVersionUID = -1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RandomChooserPanel.this.onClickAdd(e);
                    }
                });
                gbc.gridx = 1;
                gbc.gridy = 2;
                gbc.weightx = 0.0;
                this.add((Component)btnAdd, gbc);
            }
            this.updateButtonState();
        }

        public void addActionListener(ActionListener l) {
            this.listeners.add(ActionListener.class, l);
        }

        public void removeActionListener(ActionListener l) {
            this.listeners.remove(ActionListener.class, l);
        }

        public boolean isEnableRandom() {
            return this.label.isSelected();
        }

        public void setEnableRandom(boolean selected) {
            this.label.setSelected(selected);
        }

        public PartsIdentifier getSelectedPartsIdentifier() {
            return (PartsIdentifier)this.partsCombo.getSelectedItem();
        }

        public void setSelectedPartsIdentifier(PartsIdentifier partsIdentifier) {
            this.partsCombo.setSelectedItem(partsIdentifier);
        }

        protected void updateButtonState() {
            PartsIdentifier partsIdentifier = this.getSelectedPartsIdentifier();
            if (partsIdentifier == null) {
                this.btnReject.setEnabled(false);
                return;
            }
            boolean exclude = PartsRandomChooserDialog.this.partsSync.isExcludePartsIdentifier(partsIdentifier);
            this.btnReject.setSelected(exclude);
            this.btnReject.setEnabled(true);
        }

        protected void onSelectChangePartsIdentifier(ActionEvent e) {
            this.updateButtonState();
            ActionEvent evt = new ActionEvent(this, 1001, "selectChangePartsIdentifier");
            for (ActionListener l : (ActionListener[])this.listeners.getListeners(ActionListener.class)) {
                l.actionPerformed(evt);
            }
        }

        protected void onClickReject(ActionEvent e) {
            PartsIdentifier partsIdentifier = this.getSelectedPartsIdentifier();
            if (partsIdentifier == null) {
                return;
            }
            boolean exclude = PartsRandomChooserDialog.this.partsSync.isExcludePartsIdentifier(partsIdentifier);
            PartsRandomChooserDialog.this.partsSync.setExcludePartsIdentifier(partsIdentifier, !exclude);
            this.updateButtonState();
        }

        protected void onClickRandom(ActionEvent e) {
            this.selectRandom();
        }

        public void selectRandom() {
            ArrayList<PartsIdentifier> partsIdentifiers = new ArrayList<PartsIdentifier>();
            int mx = this.partsCombo.getItemCount();
            for (int idx = 0; idx < mx; ++idx) {
                PartsIdentifier partsIdentifier = (PartsIdentifier)this.partsCombo.getItemAt(idx);
                if (partsIdentifier == null || PartsRandomChooserDialog.this.partsSync.isExcludePartsIdentifier(partsIdentifier)) continue;
                partsIdentifiers.add(partsIdentifier);
            }
            int len = partsIdentifiers.size();
            if (len == 0) {
                return;
            }
            Random rng = new Random();
            int selidx = rng.nextInt(len);
            this.setSelectedPartsIdentifier((PartsIdentifier)partsIdentifiers.get(selidx));
        }

        protected void onClickAdd(ActionEvent e) {
        }
    }

    public static interface PartsSetSynchronizer {
        public PartsSet getCurrentPartsSet();

        public void setPartsSet(PartsSet var1);

        public boolean isExcludePartsIdentifier(PartsIdentifier var1);

        public void setExcludePartsIdentifier(PartsIdentifier var1, boolean var2);
    }
}

