/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuData
extends AbstractCollection<MenuData> {
    private String name;
    private boolean checkbox;
    private String text;
    private Character mnemonic;
    private String mnemonicDisp;
    private boolean ignoreMacOSX;
    private String shortcutKey;
    private ActionListener actionListener;
    private ArrayList<MenuData> children = new ArrayList();

    public MenuData() {
        this(null, false, null, null, false, null, null);
    }

    public MenuData(String text, boolean checkbox, Character mnemonic, String mnemonicDisp, boolean ignoreMacOSX, String shortcutKey, ActionListener actionListener) {
        this.text = text;
        this.checkbox = checkbox;
        this.mnemonic = mnemonic;
        this.mnemonicDisp = mnemonicDisp;
        this.ignoreMacOSX = ignoreMacOSX;
        this.shortcutKey = shortcutKey;
        this.actionListener = actionListener;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setCheckbox(boolean checkbox) {
        this.checkbox = checkbox;
    }

    public boolean isCheckbox() {
        return this.checkbox;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Character getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(Character mnemonic) {
        this.mnemonic = mnemonic;
    }

    public String getMnemonicDisp() {
        return this.mnemonicDisp;
    }

    public void setMnimonicDisp(String mnemonicDisp) {
        this.mnemonicDisp = mnemonicDisp;
    }

    public boolean isIgnoreMacOSX() {
        return this.ignoreMacOSX;
    }

    public void setIgnoreMacOSX(boolean ignoreMacOSX) {
        this.ignoreMacOSX = ignoreMacOSX;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public String getShortcutKey() {
        return this.shortcutKey;
    }

    public void setShortcutKey(String shortcutKey) {
        this.shortcutKey = shortcutKey;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public Iterator<MenuData> iterator() {
        return this.children.iterator();
    }

    @Override
    public boolean add(MenuData o) {
        return this.children.add(o);
    }

    public boolean makeMenu(JMenuItem menu) {
        if (!this.isIgnoreMacOSX() || !Main.isMacOSX()) {
            if (Main.isMacOSX()) {
                menu.setText(this.getText());
            } else {
                Character mnemonic = this.getMnemonic();
                String mnemonicDisp = this.getMnemonicDisp();
                if (mnemonicDisp == null) {
                    mnemonicDisp = "";
                }
                menu.setName(this.getName());
                menu.setText(this.getText() + mnemonicDisp);
                if (mnemonic != null) {
                    menu.setMnemonic(mnemonic.charValue());
                }
            }
            if (this.actionListener != null) {
                menu.addActionListener(this.actionListener);
            }
            if (this.shortcutKey != null && this.shortcutKey.length() > 0) {
                this.shortcutKey = Main.isMacOSX() ? this.shortcutKey.replace("?", "meta") : this.shortcutKey.replace("?", "control");
                KeyStroke ks = KeyStroke.getKeyStroke(this.shortcutKey);
                if (ks != null) {
                    menu.setAccelerator(ks);
                }
            }
            return true;
        }
        return false;
    }
}

