/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.Main;
import charactermanaj.ui.MiniPictureBox;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ImagePreviewFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -66951985128705674L;
    private MiniPictureBox previewPanel;

    public ImagePreviewFileChooser() {
        this.initAccessory();
        this.initFileFilter();
    }

    public ImagePreviewFileChooser(File initDir) {
        super(initDir);
        this.initAccessory();
        this.initFileFilter();
    }

    protected Image getSelectedImage() {
        return this.previewPanel.getImage();
    }

    protected void setSelectedImage(Image selectedImage) {
        this.previewPanel.setImage(selectedImage);
    }

    protected Image loadImage(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.createImage(file.getPath());
    }

    protected void initAccessory() {
        this.previewPanel = this.createAccessory();
        this.previewPanel.setVisible(true);
        this.setAccessory(this.previewPanel);
        this.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImagePreviewFileChooser.this.previewPanel.setImage(ImagePreviewFileChooser.this.loadImage(ImagePreviewFileChooser.this.getSelectedFile()));
            }
        });
    }

    protected MiniPictureBox createAccessory() {
        MiniPictureBox pictureBox = new MiniPictureBox();
        pictureBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, Main.isLinuxOrMacOSX() ? 5 : 10, 0, Main.isLinuxOrMacOSX() ? 5 : 0), pictureBox.getBorder()));
        return pictureBox;
    }

    protected void initFileFilter() {
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(this.createImageFileFilter());
    }

    protected FileFilter createImageFileFilter() {
        return new FileFilter(){
            private final String[] acceptExts = new String[]{".png", ".jpeg", ".jpg", ".gif", ".bmp"};

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String lcName = f.getName().toLowerCase();
                for (String acceptExt : this.acceptExts) {
                    if (!lcName.endsWith(acceptExt)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Picture(*.jpeg;*.png;*.gif;*.bmp)";
            }
        };
    }
}

