/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.ImageCacheMBean;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public final class ImageCacheMBeanImpl
implements ImageCacheMBean {
    private static ImageCacheMBeanImpl singleton = new ImageCacheMBeanImpl();
    private long readCount;
    private long cacheHitCount;
    private long totalBytes;
    private long maxBytes;
    private int totalCount;
    private int instanceCount;

    private ImageCacheMBeanImpl() {
    }

    public static ImageCacheMBeanImpl getSingleton() {
        return singleton;
    }

    public static void setupMBean() throws JMException {
        MBeanServer srv = ManagementFactory.getPlatformMBeanServer();
        srv.registerMBean(new StandardMBean(singleton, ImageCacheMBean.class), new ObjectName("CharacterManaJ:type=ImageCache,name=Singleton"));
    }

    @Override
    public synchronized long getReadCount() {
        return this.readCount;
    }

    public synchronized void setReadCount(long readCount) {
        this.readCount = readCount;
    }

    @Override
    public synchronized long getCacheHitCount() {
        return this.cacheHitCount;
    }

    public synchronized void setCacheHitCount(long cacheHitCount) {
        this.cacheHitCount = cacheHitCount;
    }

    @Override
    public synchronized long getTotalBytes() {
        return this.totalBytes;
    }

    public synchronized void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    @Override
    public synchronized long getMaxBytes() {
        return this.maxBytes;
    }

    public synchronized void setMaxBytes(long maxBytes) {
        this.maxBytes = maxBytes;
    }

    public synchronized void incrementReadCount(boolean cacheHit) {
        ++this.readCount;
        if (cacheHit) {
            ++this.cacheHitCount;
        }
    }

    public synchronized void cacheIn(long bytes) {
        ++this.totalCount;
        this.totalBytes += bytes;
        if (this.totalBytes > this.maxBytes) {
            this.maxBytes = this.totalBytes;
        }
    }

    public synchronized void cacheOut(long bytes) {
        --this.totalCount;
        this.totalBytes -= bytes;
    }

    @Override
    public synchronized int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public synchronized int getInstanceCount() {
        return this.instanceCount;
    }

    public synchronized void incrementInstance() {
        ++this.instanceCount;
    }

    public synchronized void decrementInstance() {
        --this.instanceCount;
    }

    @Override
    public synchronized void reset() {
        this.cacheHitCount = 0L;
        this.readCount = 0L;
        this.totalCount = 0;
        this.totalBytes = 0L;
        this.maxBytes = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ImageCacheMBeanImpl imageCacheMBeanImpl = this;
        synchronized (imageCacheMBeanImpl) {
            StringBuilder buf = new StringBuilder();
            buf.append("imageCacheMBean ");
            buf.append(this.cacheHitCount);
            buf.append("/");
            buf.append(this.readCount);
            return buf.toString();
        }
    }
}

