/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.scenario.animation.NumberTangentInterpolator;
import com.sun.scenario.animation.SplineInterpolator;
import javafx.animation.Interpolatable;
import javafx.util.Duration;

public abstract class Interpolator {
    private static final double EPSILON = 1.0E-12;
    public static final Interpolator DISCRETE = new Interpolator(){

        @Override
        protected double curve(double t) {
            return Math.abs(t - 1.0) < 1.0E-12 ? 1.0 : 0.0;
        }

        public String toString() {
            return "Interpolator.DISCRETE";
        }
    };
    public static final Interpolator LINEAR = new Interpolator(){

        @Override
        protected double curve(double t) {
            return t;
        }

        public String toString() {
            return "Interpolator.LINEAR";
        }
    };
    public static final Interpolator EASE_BOTH = new Interpolator(){

        @Override
        protected double curve(double t) {
            return Interpolator.clamp(t < 0.2 ? 3.125 * t * t : (t > 0.8 ? -3.125 * t * t + 6.25 * t - 2.125 : 1.25 * t - 0.125));
        }

        public String toString() {
            return "Interpolator.EASE_BOTH";
        }
    };
    public static final Interpolator EASE_IN = new Interpolator(){
        private static final double S1 = 2.7777777777777777;
        private static final double S3 = 1.1111111111111112;
        private static final double S4 = 0.1111111111111111;

        @Override
        protected double curve(double t) {
            return Interpolator.clamp(t < 0.2 ? 2.7777777777777777 * t * t : 1.1111111111111112 * t - 0.1111111111111111);
        }

        public String toString() {
            return "Interpolator.EASE_IN";
        }
    };
    public static final Interpolator EASE_OUT = new Interpolator(){
        private static final double S1 = -2.7777777777777777;
        private static final double S2 = 5.555555555555555;
        private static final double S3 = -1.7777777777777777;
        private static final double S4 = 1.1111111111111112;

        @Override
        protected double curve(double t) {
            return Interpolator.clamp(t > 0.8 ? -2.7777777777777777 * t * t + 5.555555555555555 * t + -1.7777777777777777 : 1.1111111111111112 * t);
        }

        public String toString() {
            return "Interpolator.EASE_OUT";
        }
    };

    protected Interpolator() {
    }

    public static Interpolator SPLINE(double x1, double y1, double x2, double y2) {
        return new SplineInterpolator(x1, y1, x2, y2);
    }

    public static Interpolator TANGENT(Duration t1, double v1, Duration t2, double v2) {
        return new NumberTangentInterpolator(t1, v1, t2, v2);
    }

    public static Interpolator TANGENT(Duration t, double v) {
        return new NumberTangentInterpolator(t, v);
    }

    public Object interpolate(Object startValue, Object endValue, double fraction) {
        if (startValue instanceof Number && endValue instanceof Number) {
            double start = ((Number)startValue).doubleValue();
            double end = ((Number)endValue).doubleValue();
            double val = start + (end - start) * this.curve(fraction);
            if (startValue instanceof Double || endValue instanceof Double) {
                return val;
            }
            if (startValue instanceof Float || endValue instanceof Float) {
                return Float.valueOf((float)val);
            }
            if (startValue instanceof Long || endValue instanceof Long) {
                return Math.round(val);
            }
            return (int)Math.round(val);
        }
        if (startValue instanceof Interpolatable && endValue instanceof Interpolatable) {
            return ((Interpolatable)startValue).interpolate(endValue, this.curve(fraction));
        }
        return this.curve(fraction) == 1.0 ? endValue : startValue;
    }

    public boolean interpolate(boolean startValue, boolean endValue, double fraction) {
        return Math.abs(this.curve(fraction) - 1.0) < 1.0E-12 ? endValue : startValue;
    }

    public double interpolate(double startValue, double endValue, double fraction) {
        return startValue + (endValue - startValue) * this.curve(fraction);
    }

    public int interpolate(int startValue, int endValue, double fraction) {
        return startValue + (int)Math.round((double)(endValue - startValue) * this.curve(fraction));
    }

    public long interpolate(long startValue, long endValue, double fraction) {
        return startValue + Math.round((double)(endValue - startValue) * this.curve(fraction));
    }

    private static double clamp(double t) {
        return t < 0.0 ? 0.0 : (t > 1.0 ? 1.0 : t);
    }

    protected abstract double curve(double var1);
}

