/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.paint;

import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.impl.paint.LinearGradientContext;
import com.sun.prism.impl.paint.MultipleGradientContext;
import com.sun.prism.impl.paint.RadialGradientContext;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.paint.Stop;

public class PaintUtil {
    private static final Affine2D gradXform = new Affine2D();

    public static void fillImageWithGradient(int[] pixels, Gradient grad, BaseTransform xform, int px, int py, int pw, int ph, float bx, float by, float bw, float bh) {
        MultipleGradientContext context;
        Gradient mgrad = grad;
        int numStops = mgrad.getNumStops();
        float[] fractions = new float[numStops];
        Color[] colors = new Color[numStops];
        for (int i = 0; i < numStops; ++i) {
            Stop stop = mgrad.getStops().get(i);
            fractions[i] = stop.getOffset();
            colors[i] = stop.getColor();
        }
        if (grad.getType() == Paint.Type.LINEAR_GRADIENT) {
            float y2;
            float x2;
            float y1;
            float x1;
            LinearGradient lgrad = (LinearGradient)grad;
            if (lgrad.isProportional()) {
                x1 = lgrad.getX1() * bw + bx;
                y1 = lgrad.getY1() * bh + by;
                x2 = lgrad.getX2() * bw + bx;
                y2 = lgrad.getY2() * bh + by;
            } else {
                x1 = lgrad.getX1();
                y1 = lgrad.getY1();
                x2 = lgrad.getX2();
                y2 = lgrad.getY2();
            }
            if (x1 == x2 && y1 == y2) {
                x1 -= 1.0E-6f;
                x2 += 1.0E-6f;
            }
            context = new LinearGradientContext(lgrad, xform, x1, y1, x2, y2, fractions, colors, lgrad.getSpreadMethod());
        } else {
            RadialGradient rgrad = (RadialGradient)grad;
            gradXform.setTransform(xform);
            float radius = rgrad.getRadius();
            float cx = rgrad.getCenterX();
            float cy = rgrad.getCenterY();
            double fa = Math.toRadians(rgrad.getFocusAngle());
            float fd = rgrad.getFocusDistance();
            if (rgrad.isProportional()) {
                float bcx = bx + bw / 2.0f;
                float bcy = by + bh / 2.0f;
                float scale = Math.min(bw, bh);
                cx = (cx - 0.5f) * scale + bcx;
                cy = (cy - 0.5f) * scale + bcy;
                if (bw != bh && bw != 0.0f && bh != 0.0f) {
                    gradXform.translate(bcx, bcy);
                    gradXform.scale(bw / scale, bh / scale);
                    gradXform.translate(-bcx, -bcy);
                }
                radius *= scale;
            }
            if (radius <= 0.0f) {
                radius = 0.001f;
            }
            float fx = (float)((double)cx + (double)(fd *= radius) * Math.cos(fa));
            float fy = (float)((double)cy + (double)fd * Math.sin(fa));
            context = new RadialGradientContext(rgrad, gradXform, cx, cy, radius, fx, fy, fractions, colors, rgrad.getSpreadMethod());
        }
        ((MultipleGradientContext)context).fillRaster(pixels, 0, 0, px, py, pw, ph);
    }
}

