/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.prism.PixelSource;
import com.sun.prism.impl.BufferUtil;
import java.lang.ref.WeakReference;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

public class QueuedPixelSource
implements PixelSource {
    private volatile Pixels beingConsumed;
    private volatile Pixels enqueued;
    private final List<WeakReference<Pixels>> saved = new ArrayList<WeakReference<Pixels>>(3);
    private final boolean useDirectBuffers;

    public QueuedPixelSource(boolean useDirectBuffers) {
        this.useDirectBuffers = useDirectBuffers;
    }

    @Override
    public synchronized Pixels getLatestPixels() {
        if (this.beingConsumed != null) {
            throw new IllegalStateException("already consuming pixels: " + this.beingConsumed);
        }
        if (this.enqueued != null) {
            this.beingConsumed = this.enqueued;
            this.enqueued = null;
        }
        return this.beingConsumed;
    }

    @Override
    public synchronized void doneWithPixels(Pixels used) {
        if (this.beingConsumed != used) {
            throw new IllegalStateException("wrong pixels buffer: " + used + " != " + this.beingConsumed);
        }
        this.beingConsumed = null;
    }

    @Override
    public synchronized void skipLatestPixels() {
        if (this.beingConsumed != null) {
            throw new IllegalStateException("cannot skip while processing: " + this.beingConsumed);
        }
        this.enqueued = null;
    }

    private boolean usesSameBuffer(Pixels p1, Pixels p2) {
        if (p1 == p2) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        return p1.getPixels() == p2.getPixels();
    }

    public synchronized Pixels getUnusedPixels(int w, int h, float scale) {
        int i = 0;
        IntBuffer reuseBuffer = null;
        while (i < this.saved.size()) {
            WeakReference<Pixels> ref = this.saved.get(i);
            Pixels p = (Pixels)ref.get();
            if (p == null) {
                this.saved.remove(i);
                continue;
            }
            if (this.usesSameBuffer(p, this.beingConsumed) || this.usesSameBuffer(p, this.enqueued)) {
                ++i;
                continue;
            }
            if (p.getWidthUnsafe() == w && p.getHeightUnsafe() == h && p.getScaleUnsafe() == scale) {
                return p;
            }
            this.saved.remove(i);
            reuseBuffer = (IntBuffer)p.getPixels();
            if (reuseBuffer.capacity() >= w * h) break;
            reuseBuffer = null;
        }
        if (reuseBuffer == null) {
            int bufsize = w * h;
            reuseBuffer = this.useDirectBuffers ? BufferUtil.newIntBuffer(bufsize) : IntBuffer.allocate(bufsize);
        }
        Pixels p = Application.GetApplication().createPixels(w, h, reuseBuffer, scale);
        this.saved.add(new WeakReference<Pixels>(p));
        return p;
    }

    public synchronized void enqueuePixels(Pixels pixels) {
        this.enqueued = pixels;
    }
}

