/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.monocle.IntSet;
import com.sun.glass.ui.monocle.MonocleApplication;
import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.MouseState;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.RunnableProcessor;
import java.util.BitSet;

class MouseInput {
    private static MouseInput instance = new MouseInput();
    private MouseState state = new MouseState();
    private IntSet buttons = new IntSet();
    private boolean dragInProgress = false;
    private int dragButton = 211;
    private MonocleView dragView = null;
    private BitSet dragActions = new BitSet();
    private static final int DRAG_ENTER = 1;
    private static final int DRAG_LEAVE = 2;
    private static final int DRAG_OVER = 3;
    private static final int DRAG_DROP = 4;

    MouseInput() {
    }

    static MouseInput getInstance() {
        return instance;
    }

    void getState(MouseState result) {
        this.state.copyTo(result);
    }

    void setState(MouseState newState, boolean synthesized) {
        boolean isPopupTrigger;
        int button;
        int i;
        int modifiers;
        boolean newAbsoluteLocation;
        MonocleView view;
        if (MonocleSettings.settings.traceEvents) {
            MonocleTrace.traceEvent("Set %s", newState);
        }
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        int x = Math.max(0, Math.min(newState.getX(), screen.getWidth() - 1));
        int y = Math.max(0, Math.min(newState.getY(), screen.getHeight() - 1));
        newState.setX(x);
        newState.setY(y);
        MonocleWindow oldWindow = this.state.getWindow(false);
        boolean recalculateWindow = this.state.getButtonsPressed().isEmpty();
        MonocleWindow window = newState.getWindow(recalculateWindow);
        MonocleView monocleView = view = window == null ? null : (MonocleView)window.getView();
        if (oldWindow != window && oldWindow != null) {
            if (!oldWindow.isEnabled()) {
                RunnableProcessor.runLater(() -> MonocleWindowManager.getInstance().notifyFocusDisabled(oldWindow));
            } else {
                MonocleView oldView = (MonocleView)oldWindow.getView();
                if (oldView != null) {
                    int modifiers2 = this.state.getModifiers();
                    int button2 = this.state.getButton();
                    boolean isPopupTrigger2 = false;
                    int oldX = this.state.getX();
                    int oldY = this.state.getY();
                    int oldRelX = oldX - oldWindow.getX();
                    int oldRelY = oldY - oldWindow.getY();
                    try {
                        this.postMouseEvent(oldView, 226, button2, oldRelX, oldRelY, oldX, oldY, modifiers2, isPopupTrigger2, synthesized);
                    }
                    catch (RuntimeException e) {
                        Application.reportException(e);
                    }
                }
            }
        }
        boolean bl = newAbsoluteLocation = this.state.getX() != x || this.state.getY() != y;
        if (newAbsoluteLocation) {
            NativePlatformFactory.getNativePlatform().getCursor().setLocation(x, y);
        }
        if (view == null) {
            newState.copyTo(this.state);
            return;
        }
        if (window != null && !window.isEnabled()) {
            newState.copyTo(this.state);
            RunnableProcessor.runLater(() -> MonocleWindowManager.getInstance().notifyFocusDisabled(window));
            return;
        }
        int relX = x - window.getX();
        int relY = y - window.getY();
        if (oldWindow != window && view != null) {
            int modifiers3 = this.state.getModifiers();
            int button3 = this.state.getButton();
            boolean isPopupTrigger3 = false;
            this.postMouseEvent(view, 225, button3, relX, relY, x, y, modifiers3, isPopupTrigger3, synthesized);
        }
        if (oldWindow != window | newAbsoluteLocation) {
            boolean isDrag = !this.state.getButtonsPressed().isEmpty();
            int eventType = isDrag ? 223 : 224;
            modifiers = this.state.getModifiers();
            int button4 = this.state.getButton();
            boolean isPopupTrigger4 = false;
            this.postMouseEvent(view, eventType, button4, relX, relY, x, y, modifiers, isPopupTrigger4, synthesized);
        }
        newState.getButtonsPressed().difference(this.buttons, this.state.getButtonsPressed());
        if (!this.buttons.isEmpty()) {
            MouseState pressState = new MouseState();
            this.state.copyTo(pressState);
            for (i = 0; i < this.buttons.size(); ++i) {
                button = this.buttons.get(i);
                pressState.pressButton(button);
                isPopupTrigger = false;
                this.postMouseEvent(view, 221, button, relX, relY, x, y, pressState.getModifiers(), isPopupTrigger, synthesized);
            }
        }
        this.buttons.clear();
        this.state.getButtonsPressed().difference(this.buttons, newState.getButtonsPressed());
        if (!this.buttons.isEmpty()) {
            MouseState releaseState = new MouseState();
            this.state.copyTo(releaseState);
            for (i = 0; i < this.buttons.size(); ++i) {
                button = this.buttons.get(i);
                releaseState.releaseButton(button);
                isPopupTrigger = false;
                this.postMouseEvent(view, 222, button, relX, relY, x, y, releaseState.getModifiers(), isPopupTrigger, synthesized);
            }
        }
        this.buttons.clear();
        if (newState.getWheel() != this.state.getWheel()) {
            double dY;
            switch (newState.getWheel()) {
                case -1: {
                    dY = -1.0;
                    break;
                }
                case 1: {
                    dY = 1.0;
                    break;
                }
                default: {
                    dY = 0.0;
                }
            }
            if (dY != 0.0) {
                modifiers = newState.getModifiers();
                RunnableProcessor.runLater(() -> view.notifyScroll(relX, relY, x, y, 0.0, dY, modifiers, 1, 0, 0, 0, 1.0, 1.0));
            }
            newState.setWheel(0);
        }
        newState.copyTo(this.state);
    }

    private void postMouseEvent(MonocleView view, int eventType, int button, int relX, int relY, int x, int y, int modifiers, boolean isPopupTrigger, boolean synthesized) {
        RunnableProcessor.runLater(() -> this.notifyMouse(view, eventType, button, relX, relY, x, y, modifiers, isPopupTrigger, synthesized));
    }

    private void notifyMouse(MonocleView view, int eventType, int button, int relX, int relY, int x, int y, int modifiers, boolean isPopupTrigger, boolean synthesized) {
        switch (eventType) {
            case 221: {
                if (this.dragButton != 211) break;
                this.dragButton = button;
                break;
            }
            case 222: {
                if (this.dragButton != button) break;
                this.dragButton = 211;
                if (!this.dragInProgress) break;
                try {
                    view.notifyDragDrop(relX, relY, x, y, 2);
                }
                catch (RuntimeException e) {
                    Application.reportException(e);
                }
                try {
                    view.notifyDragEnd(2);
                }
                catch (RuntimeException e) {
                    Application.reportException(e);
                }
                ((MonocleApplication)Application.GetApplication()).leaveDndEventLoop();
                this.dragActions.clear();
                this.dragView = null;
                this.dragInProgress = false;
                break;
            }
            case 223: {
                if (this.dragButton == 211) break;
                if (this.dragInProgress) {
                    if (this.dragView == view && this.dragActions.isEmpty()) {
                        try {
                            view.notifyDragEnter(relX, relY, x, y, 2);
                        }
                        catch (RuntimeException e) {
                            Application.reportException(e);
                        }
                        this.dragActions.set(1);
                    } else if (this.dragView == view && this.dragActions.get(1)) {
                        try {
                            view.notifyDragOver(relX, relY, x, y, 2);
                        }
                        catch (RuntimeException e) {
                            Application.reportException(e);
                        }
                        this.dragActions.set(3);
                    } else if (this.dragView != view) {
                        if (this.dragView != null) {
                            try {
                                this.dragView.notifyDragLeave();
                            }
                            catch (RuntimeException e) {
                                Application.reportException(e);
                            }
                        }
                        try {
                            view.notifyDragEnter(relX, relY, x, y, 2);
                        }
                        catch (RuntimeException e) {
                            Application.reportException(e);
                        }
                        this.dragActions.clear();
                        this.dragActions.set(1);
                        this.dragView = view;
                    }
                    return;
                }
                if (this.dragView != null) break;
                this.dragView = view;
            }
        }
        view.notifyMouse(eventType, button, relX, relY, x, y, modifiers, isPopupTrigger, synthesized);
    }

    void notifyDragStart() {
        this.dragInProgress = true;
    }
}

