/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxEventBuffer;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.LinuxTouchProcessor;
import com.sun.glass.ui.monocle.LookaheadTouchFilter;
import com.sun.glass.ui.monocle.TouchState;
import java.util.HashMap;
import java.util.Map;

class LinuxStatefulMultiTouchProcessor
extends LinuxTouchProcessor {
    private static final int ID_UNASSIGNED = -1;
    private static final int COORD_UNDEFINED = Integer.MIN_VALUE;
    private int currentID = -1;
    private int currentSlot = 0;
    private final Map<Integer, Integer> slotToIDMap = new HashMap<Integer, Integer>();

    LinuxStatefulMultiTouchProcessor(LinuxInputDevice device) {
        super(device);
        this.pipeline.addFilter(new LookaheadTouchFilter(false));
    }

    @Override
    public void processEvents(LinuxInputDevice device) {
        LinuxEventBuffer buffer = device.getBuffer();
        int x = Integer.MIN_VALUE;
        int y = Integer.MIN_VALUE;
        boolean allPointsReleased = false;
        while (buffer.hasNextEvent()) {
            block0 : switch (buffer.getEventType()) {
                case 3: {
                    int value = this.transform.getValue(buffer);
                    switch (this.transform.getAxis(buffer)) {
                        case 47: {
                            if (this.currentID != -1 && (x != Integer.MIN_VALUE || y != Integer.MIN_VALUE)) {
                                this.updatePoint(x, y);
                                y = Integer.MIN_VALUE;
                                x = Integer.MIN_VALUE;
                            }
                            this.currentSlot = value;
                            this.currentID = this.slotToIDMap.getOrDefault(this.currentSlot, -1);
                            break;
                        }
                        case 57: {
                            if (value == -1 && this.currentID != -1) {
                                this.state.removePointForID(this.currentID);
                            }
                            this.currentID = value;
                            if (this.currentID == -1) {
                                this.slotToIDMap.remove(this.currentSlot);
                                break;
                            }
                            this.slotToIDMap.put(this.currentSlot, this.currentID);
                            break;
                        }
                        case 0: 
                        case 53: {
                            if (x != Integer.MIN_VALUE) break;
                            x = value;
                            break;
                        }
                        case 1: 
                        case 54: {
                            if (y != Integer.MIN_VALUE) break;
                            y = value;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (buffer.getEventCode()) {
                        case 330: {
                            if (buffer.getEventValue() != 0) break;
                            allPointsReleased = true;
                        }
                    }
                    break;
                }
                case 0: {
                    switch (buffer.getEventCode()) {
                        case 2: {
                            if (this.currentID != -1) {
                                if (x == Integer.MIN_VALUE && y == Integer.MIN_VALUE) {
                                    this.state.removePointForID(this.currentID);
                                    this.currentID = -1;
                                } else {
                                    this.updatePoint(x, y);
                                }
                            }
                            y = Integer.MIN_VALUE;
                            x = Integer.MIN_VALUE;
                            break block0;
                        }
                        case 0: {
                            if ((x != Integer.MIN_VALUE || y != Integer.MIN_VALUE) && this.currentID != -1) {
                                this.updatePoint(x, y);
                            } else if (allPointsReleased) {
                                this.state.clear();
                            }
                            this.pipeline.pushState(this.state);
                            y = Integer.MIN_VALUE;
                            x = Integer.MIN_VALUE;
                            allPointsReleased = false;
                            break block0;
                        }
                    }
                }
            }
            buffer.nextEvent();
        }
        this.pipeline.flush();
    }

    private void updatePoint(int x, int y) {
        TouchState.Point p = this.state.getPointForID(this.currentID);
        if (p == null) {
            p = new TouchState.Point();
            p.id = this.currentID;
            p = this.state.addPoint(p);
        }
        if (x != Integer.MIN_VALUE) {
            p.x = x;
        }
        if (y != Integer.MIN_VALUE) {
            p.y = y;
        }
    }
}

