/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.ColorConvertedImageKey;
import charactermanaj.graphics.ColorConvertedImageLoaderImpl;
import charactermanaj.graphics.colormodel.ColorModel;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageCache;
import charactermanaj.graphics.io.ImageCachedLoader;
import charactermanaj.graphics.io.ImageLoader;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.LoadedImage;
import java.io.IOException;

public class ColorConvertedImageCachedLoader
extends ColorConvertedImageLoaderImpl {
    private ImageCache<ColorConvertedImageKey> caches = new ImageCache();

    public ColorConvertedImageCachedLoader() {
        this(new ImageCachedLoader());
    }

    public ColorConvertedImageCachedLoader(ImageLoader imageLoader) {
        super(imageLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedImage load(ImageResource file, ColorConvertParameter colorConvParam, ColorModel colorModel) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        ColorConvertParameter param = colorConvParam == null ? new ColorConvertParameter() : colorConvParam.clone();
        ColorConvertedImageKey key = new ColorConvertedImageKey(param, file);
        ImageCache<ColorConvertedImageKey> imageCache = this.caches;
        synchronized (imageCache) {
            LoadedImage loadedImage = this.caches.get(key);
            if (loadedImage == null) {
                loadedImage = super.load(file, param, colorModel);
                this.caches.set(key, loadedImage);
            }
            return loadedImage;
        }
    }

    public void unlockImages() {
        this.caches.unlockImages();
    }
}

