package charactermanaj.model;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;

public class WorkingSet implements Serializable {

	private static final long serialVersionUID = -4728766140876842242L;

	private Map<PartsIdentifier, PartsColorInfo> partsColorInfoMap;
	
	private String characterDataRev;
	
	private PartsSet partsSet;
	
	private URL characterDocBase;
	
	private File lastUsedSaveDir;
	
	private File lastUsedExportDir;
	
	
	public void setCharacterDataRev(String characterDataRev) {
		this.characterDataRev = characterDataRev;
	}
	
	public String getCharacterDataRev() {
		return characterDataRev;
	}
	
	public Map<PartsIdentifier, PartsColorInfo> getPartsColorInfoMap() {
		return partsColorInfoMap;
	}
	
	public void setPartsColorInfoMap(
			Map<PartsIdentifier, PartsColorInfo> partsColorInfoMap) {
		this.partsColorInfoMap = partsColorInfoMap;
	}
	
	public void setCharacterDocBase(URL characterDocBase) {
		this.characterDocBase = characterDocBase;
	}
	
	public void setPartsSet(PartsSet partsSet) {
		this.partsSet = partsSet;
	}
	
	public URL getCharacterDocBase() {
		return characterDocBase;
	}
	
	public PartsSet getPartsSet() {
		return partsSet;
	}
	
	public void setLastUsedSaveDir(File lastUsedSaveDir) {
		this.lastUsedSaveDir = lastUsedSaveDir;
	}
	
	public void setLastUsedExportDir(File lastUsedExportDir) {
		this.lastUsedExportDir = lastUsedExportDir;
	}
	
	public File getLastUsedSaveDir() {
		return lastUsedSaveDir;
	}
	
	public File getLastUsedExportDir() {
		return lastUsedExportDir;
	}
	
	@Override
	public String toString() {
		return "docBase:" + characterDocBase + "/rev:" + characterDataRev;
	}
}
