package charactermanaj.graphics.filters;

import java.io.Serializable;

public final class ColorConvertParameter implements Serializable, Cloneable {

	private static final long serialVersionUID = 3092895708547846162L;

	private ColorConv colorReplace;
	
	private float grayLevel = 1.f;
	
	private float hue = 0.f;
	
	private float saturation = 0.f;

	private float brightness = 0.f;

	private int offsetR = 0;

	private int offsetG = 0;

	private int offsetB = 0;

	private int offsetA = 0;
	
	private float factorR = 1.f;

	private float factorG = 1.f;

	private float factorB = 1.f;

	private float factorA = 1.f;
	
	private float gammaR = 1.f;

	private float gammaG = 1.f;

	private float gammaB = 1.f;

	private float gammaA = 1.f;
	

	@Override
	public int hashCode() {
		int ret = 0;
		if (colorReplace != null) {
			ret = colorReplace.ordinal();
		}
		ret ^= (int)(grayLevel * 100);
		ret ^= (int)(hue * 100);
		ret ^= (int)(saturation * 100);
		ret ^= (int)(brightness * 100);
		ret ^= offsetR;
		ret ^= offsetG;
		ret ^= offsetB;
		ret ^= offsetA;
		ret ^= (int)(factorR * 100);
		ret ^= (int)(factorG * 100);
		ret ^= (int)(factorB * 100);
		ret ^= (int)(factorA * 100);
		ret ^= (int)(gammaR * 100);
		ret ^= (int)(gammaG * 100);
		ret ^= (int)(gammaB * 100);
		ret ^= (int)(gammaA * 100);
		return ret;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if (obj != null && obj instanceof ColorConvertParameter) {
			ColorConvertParameter o = (ColorConvertParameter) obj;
			return colorReplace == o.colorReplace && grayLevel == o.grayLevel
					&& hue == o.hue && saturation == o.saturation
					&& brightness == o.brightness && offsetR == o.offsetR
					&& offsetG == o.offsetG && offsetB == o.offsetB
					&& offsetA == o.offsetA && factorR == o.factorR
					&& factorG == o.factorG && factorB == o.factorB
					&& factorA == o.factorA && gammaR == o.gammaR
					&& gammaG == o.gammaG && gammaB == o.gammaB
					&& gammaA == o.gammaA;
		}
		return false;
	}
	
	@Override
	public ColorConvertParameter clone() {
		try {
			// シャローコピー. すべてimmutableな単純型だけのメンバなので問題なし.
			return (ColorConvertParameter) super.clone();
		} catch (CloneNotSupportedException e) {
			throw new Error("internal error.");
		}
	}
	
	public ColorConv getColorReplace() {
		return colorReplace;
	}

	public void setColorReplace(ColorConv colorReplace) {
		this.colorReplace = colorReplace;
	}

	public float getGrayLevel() {
		return grayLevel;
	}

	public void setGrayLevel(float grayLevel) {
		this.grayLevel = grayLevel;
	}

	public float getHue() {
		return hue;
	}

	public void setHue(float hue) {
		this.hue = hue;
	}

	public float getSaturation() {
		return saturation;
	}

	public void setSaturation(float saturation) {
		this.saturation = saturation;
	}

	public float getBrightness() {
		return brightness;
	}

	public void setBrightness(float brightness) {
		this.brightness = brightness;
	}

	public int getOffsetR() {
		return offsetR;
	}

	public void setOffsetR(int offsetR) {
		this.offsetR = offsetR;
	}

	public int getOffsetG() {
		return offsetG;
	}

	public void setOffsetG(int offsetG) {
		this.offsetG = offsetG;
	}

	public int getOffsetB() {
		return offsetB;
	}

	public void setOffsetB(int offsetB) {
		this.offsetB = offsetB;
	}

	public int getOffsetA() {
		return offsetA;
	}

	public void setOffsetA(int offsetA) {
		this.offsetA = offsetA;
	}

	public float getFactorR() {
		return factorR;
	}

	public void setFactorR(float factorR) {
		this.factorR = factorR;
	}

	public float getFactorG() {
		return factorG;
	}

	public void setFactorG(float factorG) {
		this.factorG = factorG;
	}

	public float getFactorB() {
		return factorB;
	}

	public void setFactorB(float factorB) {
		this.factorB = factorB;
	}

	public float getFactorA() {
		return factorA;
	}

	public void setFactorA(float factorA) {
		this.factorA = factorA;
	}

	public float getGammaR() {
		return gammaR;
	}

	public void setGammaR(float gammaR) {
		this.gammaR = gammaR;
	}

	public float getGammaG() {
		return gammaG;
	}

	public void setGammaG(float gammaG) {
		this.gammaG = gammaG;
	}

	public float getGammaB() {
		return gammaB;
	}

	public void setGammaB(float gammaB) {
		this.gammaB = gammaB;
	}

	public float getGammaA() {
		return gammaA;
	}

	public void setGammaA(float gammaA) {
		this.gammaA = gammaA;
	}
	
	@Override
	public String toString() {
		return getClass().getSimpleName() + "@"
				+ Integer.toHexString(System.identityHashCode(this)) + "("
				+ hue + ":" + saturation + ":" + brightness + ")";
	}
	
}
