package charactermanaj;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.UIManager;

import charactermanaj.model.AppConfig;
import charactermanaj.ui.MainFrame;
import charactermanaj.ui.ProfileSelectorDialog;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.ApplicationLogger;

/**
 * エントリポイント用クラス
 * @author seraphy
 *
 */
public class Main {
	
	/**
	 * ロガー.<br>
	 */
	private static Logger logger = ApplicationLogger.getLogger();

	/**
	 * Mac OS Xであるか?
	 */
	private static Boolean isMacOSX;
	
	/**
	 * エントリポイント.<br>
	 * 最初のメインフレームを開いたときにMac OS Xであればスクリーンメニューの登録も行う.<br>
	 * @param args 引数(未使用)
	 */
	public static void main(String[] args) {
		try {
			
			//System.setProperty("swing.aatext", "true");
			//System.setProperty("awt.useSystemAAFontSettings", "on");
			
			if (isMacOSX()) {
				System.setProperty("apple.laf.useScreenMenuBar", "true");
				System.setProperty(
						"com.apple.mrj.application.apple.menu.about.name",
						"CharacterManaJ");
			}
			
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
			
			
			AppConfig appConfig = AppConfig.getInstance();
			appConfig.loadConfig();
	
			// デフォルトのプロファイルを開く.
			// (最後に使ったプロファイルがあれば、それが開かれる.)
			MainFrame mainFrame = ProfileSelectorDialog.openDefaultProfile();
			if (isMacOSX()) {
				Class<?> clz = Class.forName("charactermanaj.ui.MainFramePartialForMacOSX");
				Method mtd = clz.getMethod("setupScreenMenu", MainFrame.class);
				mtd.invoke(null, mainFrame);
			}
			mainFrame.setVisible(true);

		} catch (Throwable ex) {
			logger.log(Level.SEVERE, "Application initiation failed.", ex);
			ErrorMessageHelper.showErrorDialog(null, ex);
			System.exit(1);
		}
	}
	
	/**
	 * Mac OS Xで動作しているか?
	 * @return Max OS X上であればtrue
	 */
	public static boolean isMacOSX() {
		if (isMacOSX == null) {
			String lcOS = System.getProperty("os.name").toLowerCase();
			isMacOSX = Boolean.valueOf(lcOS.startsWith("mac os x"));
		}
		return isMacOSX.booleanValue();
	}
	
}
