/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.ui.PartsSelectListModel;
import charactermanaj.ui.PartsSelectRow;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageSelectPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "strings/imageselectpanel";
    private static final int rowStep = 2;
    private final LinkedList<ImageSelectPanelListener> listeners = new LinkedList();
    private final int rowHeight;
    private final int minHeight;
    private PartsSpecResolver partsSpecResolver;
    private final JTable partsSelectTable;
    private final PartsSelectListModel partsSelectTableModel;
    private PartsIdentifier selectedPartsIdentifier;
    private List<PartsIdentifier> selectedPartsIdentifiers = Collections.emptyList();
    private final PartsCategory partsCategory;

    public ImageSelectPanel(final PartsCategory partsCategory, final PartsSpecResolver partsSpecResolver) {
        if (partsCategory == null || partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        this.partsCategory = partsCategory;
        this.partsSpecResolver = partsSpecResolver;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3))));
        this.partsSelectTableModel = new PartsSelectListModel(partsCategory);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn checkColumn = new TableColumn(0, 32);
        checkColumn.setMaxWidth(42);
        columnModel.addColumn(checkColumn);
        columnModel.addColumn(new TableColumn(1, 100));
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ImageSelectPanel.this.onSelectChange(new ImageSelectPanelEvent(ImageSelectPanel.this));
                }
            }
        });
        AppConfig appConfig = AppConfig.getInstance();
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        final Color selectedItemColor = appConfig.getCheckedItemBgColor();
        this.partsSelectTable = new JTable(this.partsSelectTableModel, columnModel, selectionModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                if (this.isCellSelected(row, column) && this.hasFocus()) {
                    comp.setBackground(this.getSelectionBackground());
                } else {
                    Boolean chk = (Boolean)this.getModel().getValueAt(row, 0);
                    comp.setForeground(this.getForeground());
                    if (chk.booleanValue()) {
                        comp.setBackground(selectedItemColor);
                    } else {
                        comp.setBackground(this.getBackground());
                    }
                }
                return comp;
            }

            public String getToolTipText(MouseEvent event) {
                int row = this.rowAtPoint(event.getPoint());
                int mx = ImageSelectPanel.this.partsSelectTableModel.getRowCount();
                if (row >= 0 && row < mx) {
                    PartsSelectRow rowModel = ImageSelectPanel.this.partsSelectTableModel.getRow(row);
                    PartsIdentifier partsIdentifier = rowModel.getPartsIdentifier();
                    PartsSpec partsSpec = partsSpecResolver.getPartsSpec(partsIdentifier);
                    String suffix = "";
                    if (partsSpec != null) {
                        String author = partsSpec.getAuthor();
                        double version = partsSpec.getVersion();
                        if (author != null) {
                            suffix = version > 0.0 ? " (" + author + " " + version + ")" : " (" + author + ")";
                        }
                    }
                    return partsIdentifier.getLocalizedPartsName() + suffix;
                }
                return null;
            }
        };
        this.partsSelectTable.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ImageSelectPanel.this.partsSelectTable.repaint();
            }

            public void focusLost(FocusEvent e) {
                ImageSelectPanel.this.partsSelectTable.repaint();
            }
        });
        final JPopupMenu partsSelectTablePopupMenu = new JPopupMenu();
        AbstractAction actDeselectAll = new AbstractAction(strings.getProperty("popupmenu.deselectall")){
            private static final long serialVersionUID = 9132032971228670868L;

            public void actionPerformed(ActionEvent e) {
                ImageSelectPanel.this.deselectAll();
            }
        };
        partsSelectTablePopupMenu.add(actDeselectAll);
        this.partsSelectTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.evaluatePopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.evaluatePopup(e);
            }

            private void evaluatePopup(MouseEvent e) {
                if ((partsCategory.isMultipleSelectable() || ImageSelectPanel.this.isDeselectableSingleCategory()) && e.isPopupTrigger()) {
                    partsSelectTablePopupMenu.show(ImageSelectPanel.this.partsSelectTable, e.getX(), e.getY());
                }
            }
        });
        this.partsSelectTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0) {
                    ImageSelectPanel.this.onChange(new ImageSelectPanelEvent(ImageSelectPanel.this));
                }
            }
        });
        this.partsSelectTable.setSelectionBackground(appConfig.getSelectedItemBgColor());
        if (partsCategory.isMultipleSelectable()) {
            this.partsSelectTable.setSelectionMode(2);
        } else {
            this.partsSelectTable.setSelectionMode(0);
        }
        this.partsSelectTable.setRowSelectionAllowed(true);
        this.partsSelectTable.setTableHeader(null);
        this.partsSelectTable.setAutoResizeMode(3);
        this.partsSelectTable.setShowVerticalLines(false);
        this.partsSelectTable.setShowHorizontalLines(false);
        InputMap im = this.partsSelectTable.getInputMap();
        im.put(KeyStroke.getKeyStroke(32, 0), "toggleCheck");
        im.put(KeyStroke.getKeyStroke(127, 0), "resetCheck");
        ActionMap am = this.partsSelectTable.getActionMap();
        am.put("toggleCheck", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = ImageSelectPanel.this.partsSelectTable.getSelectedRows();
                boolean[] checks = ImageSelectPanel.this.partsSelectTableModel.getChecks(selectedRows);
                int checkedCount = 0;
                for (boolean checked : checks) {
                    if (!checked) continue;
                    ++checkedCount;
                }
                if (checks.length == checkedCount) {
                    ImageSelectPanel.this.partsSelectTableModel.setChecks(false, selectedRows);
                } else {
                    ImageSelectPanel.this.partsSelectTableModel.setChecks(true, selectedRows);
                }
            }
        });
        am.put("resetCheck", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImageSelectPanel.this.partsSelectTableModel.setChecks(false, ImageSelectPanel.this.partsSelectTable.getSelectedRows());
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.partsSelectTable);
        scrollPane.setVerticalScrollBarPolicy(22);
        UIHelper uiUtl = UIHelper.getInstance();
        JButton leftBtn = uiUtl.createTransparentButton("icons/left.png", "icons/left2.png");
        JButton rightBtn = uiUtl.createTransparentButton("icons/right.png", "icons/right2.png");
        JButton colorBtn = uiUtl.createTransparentButton("icons/color.png", "icons/color2.png");
        JButton configBtn = uiUtl.createTransparentButton("icons/config.png", "icons/config2.png");
        leftBtn.setToolTipText(strings.getProperty("tooltip.shrink"));
        rightBtn.setToolTipText(strings.getProperty("tooltip.expand"));
        colorBtn.setToolTipText(strings.getProperty("tooltip.color"));
        configBtn.setToolTipText(strings.getProperty("tooltip.config"));
        leftBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageSelectPanel.this.shrink();
            }
        });
        rightBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageSelectPanel.this.expand();
            }
        });
        colorBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageSelectPanel.this.onChangeColor(new ImageSelectPanelEvent(ImageSelectPanel.this));
            }
        });
        configBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageSelectPanel.this.onPreferences(new ImageSelectPanelEvent(ImageSelectPanel.this));
            }
        });
        JPanel btnPanelGrp = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(leftBtn);
        toolBar.add(rightBtn);
        toolBar.add(colorBtn);
        btnPanelGrp.add((Component)toolBar, "North");
        if (partsCategory.isMultipleSelectable()) {
            UIHelper uiUty = UIHelper.getInstance();
            JButton upBtn = uiUty.createTransparentButton("icons/arrow_up.png", "icons/arrow_up2.png");
            JButton downBtn = uiUty.createTransparentButton("icons/arrow_down.png", "icons/arrow_down2.png");
            JButton sortBtn = uiUty.createTransparentButton("icons/sort.png", "icons/sort2.png");
            upBtn.setToolTipText(strings.getProperty("tooltip.up"));
            downBtn.setToolTipText(strings.getProperty("tooltip.down"));
            sortBtn.setToolTipText(strings.getProperty("tooltip.sort"));
            upBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageSelectPanel.this.onUp();
                }
            });
            downBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageSelectPanel.this.onDown();
                }
            });
            sortBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageSelectPanel.this.onSort();
                }
            });
            JToolBar toolBar2 = new JToolBar();
            toolBar2.setFloatable(false);
            toolBar2.add(upBtn);
            toolBar2.add(downBtn);
            toolBar2.add(sortBtn);
            btnPanelGrp.add((Component)toolBar2, "South");
        }
        JPanel header = new JPanel(new BorderLayout());
        header.add((Component)btnPanelGrp, "East");
        JLabel title = new JLabel(" " + partsCategory.getLocalizedCategoryName() + " ");
        Font font = title.getFont();
        title.setFont(font.deriveFont(1));
        header.add((Component)title, "Center");
        this.add((Component)header, "North");
        this.add((Component)scrollPane, "Center");
        this.rowHeight = this.partsSelectTable.getRowHeight();
        Insets insets = this.getInsets();
        this.minHeight = header.getPreferredSize().height + insets.top + insets.bottom;
        this.setPreferredSize(new Dimension(200, this.minHeight + this.rowHeight * partsCategory.getVisibleRows()));
    }

    public void loadParts() {
        this.partsSelectTableModel.load(this.partsSpecResolver.getPartsSpecMap(this.partsCategory).keySet());
        this.scrollToSelectedRow();
    }

    public PartsCategory getPartsCategory() {
        return this.partsCategory;
    }

    public void deselectAll() {
        PartsSelectListModel rowModelList = (PartsSelectListModel)this.partsSelectTable.getModel();
        ArrayList<PartsSelectRow> rowModels = rowModelList.getRowModelList();
        for (PartsSelectRow rowModel : rowModels) {
            rowModel.setChecked(false);
        }
        this.partsSelectTable.repaint();
        this.onChange(new ImageSelectPanelEvent(this));
    }

    public void selectParts(Collection<PartsIdentifier> partsIdentifiers) {
        if (partsIdentifiers == null) {
            partsIdentifiers = Collections.emptyList();
        }
        PartsSelectListModel rowModelList = (PartsSelectListModel)this.partsSelectTable.getModel();
        ArrayList<PartsSelectRow> rowModels = rowModelList.getRowModelList();
        for (PartsSelectRow rowModel : rowModels) {
            rowModel.setChecked(false);
        }
        ArrayList<PartsIdentifier> partsIdentifiersBuf = new ArrayList<PartsIdentifier>(partsIdentifiers);
        Collections.reverse(partsIdentifiersBuf);
        block1: for (PartsIdentifier partsIdentifier : partsIdentifiersBuf) {
            Iterator<PartsSelectRow> ite = rowModels.iterator();
            while (ite.hasNext()) {
                PartsSelectRow rowModel = ite.next();
                if (!rowModel.getPartsIdentifier().equals(partsIdentifier)) continue;
                rowModel.setChecked(true);
                if (partsIdentifiersBuf.size() < 2 || !this.partsCategory.isMultipleSelectable()) continue block1;
                ite.remove();
                rowModels.add(0, rowModel);
                continue block1;
            }
        }
        this.selectedPartsIdentifier = this.getSelectedPartsIdentifier();
        this.selectedPartsIdentifiers = this.getSelectedPartsIdentifiers();
        this.partsSelectTable.repaint();
        this.scrollToSelectedRow();
    }

    public void scrollToSelectedRow() {
        PartsSelectListModel rowModelList = (PartsSelectListModel)this.partsSelectTable.getModel();
        ArrayList<PartsSelectRow> rowModels = rowModelList.getRowModelList();
        int mx = rowModels.size();
        for (int row = 0; row < mx; ++row) {
            if (!rowModels.get(row).isChecked()) continue;
            Rectangle rct = this.partsSelectTable.getCellRect(row, 0, true);
            this.partsSelectTable.scrollRectToVisible(rct);
            break;
        }
    }

    public void shrink() {
        Dimension siz = this.getPreferredSize();
        siz.height -= this.rowHeight * 2;
        if (siz.height < this.minHeight) {
            siz.height = this.minHeight;
        }
        this.setPreferredSize(siz);
        this.revalidate();
    }

    public void expand() {
        Dimension siz = this.getPreferredSize();
        siz.height += this.rowHeight * 2;
        this.setPreferredSize(siz);
        this.revalidate();
    }

    public void addImageSelectListener(ImageSelectPanelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public void removeImageSelectListener(ImageSelectPanelListener listener) {
        this.listeners.remove(listener);
    }

    public void requestListFocus() {
        this.partsSelectTable.requestFocus();
    }

    public void setSelection(PartsIdentifier partsIdentifier) {
        if (partsIdentifier == null) {
            return;
        }
        PartsCategory partsCategory = partsIdentifier.getPartsCategory();
        if (!this.partsCategory.equals(partsCategory)) {
            return;
        }
        ArrayList<PartsSelectRow> rowModelList = ((PartsSelectListModel)this.partsSelectTable.getModel()).getRowModelList();
        int mx = rowModelList.size();
        for (int idx = 0; idx < mx; ++idx) {
            PartsSelectRow partsSelectRow = rowModelList.get(idx);
            if (!partsSelectRow.getPartsIdentifier().equals(partsIdentifier)) continue;
            this.partsSelectTable.getSelectionModel().setSelectionInterval(idx, idx);
            Rectangle rct = this.partsSelectTable.getCellRect(idx, 0, true);
            this.partsSelectTable.scrollRectToVisible(rct);
            this.partsSelectTable.requestFocus();
            return;
        }
    }

    protected void onUp() {
        int selRow = this.partsSelectTable.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        if (selRow > 0) {
            ArrayList<PartsSelectRow> rowModelList = ((PartsSelectListModel)this.partsSelectTable.getModel()).getRowModelList();
            PartsSelectRow rowModel = rowModelList.get(selRow);
            rowModelList.remove(selRow);
            rowModelList.add(selRow - 1, rowModel);
            this.partsSelectTable.setRowSelectionInterval(selRow - 1, selRow - 1);
            Rectangle rct = this.partsSelectTable.getCellRect(selRow - 1, 0, true);
            this.partsSelectTable.scrollRectToVisible(rct);
            this.onChange(new ImageSelectPanelEvent(this));
        }
        this.partsSelectTable.repaint();
        this.partsSelectTable.requestFocus();
    }

    protected void onDown() {
        int selRow = this.partsSelectTable.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        int mx = this.partsSelectTable.getRowCount();
        if (selRow < mx - 1) {
            ArrayList<PartsSelectRow> rowModelList = ((PartsSelectListModel)this.partsSelectTable.getModel()).getRowModelList();
            PartsSelectRow rowModel = rowModelList.get(selRow);
            rowModelList.remove(selRow);
            rowModelList.add(selRow + 1, rowModel);
            this.partsSelectTable.setRowSelectionInterval(selRow + 1, selRow + 1);
            Rectangle rct = this.partsSelectTable.getCellRect(selRow + 1, 0, true);
            this.partsSelectTable.scrollRectToVisible(rct);
            this.onChange(new ImageSelectPanelEvent(this));
        }
        this.partsSelectTable.repaint();
        this.partsSelectTable.requestFocus();
    }

    protected void onSort() {
        if (this.partsSelectTable.getRowCount() > 0) {
            this.partsSelectTableModel.sort();
            this.partsSelectTable.setRowSelectionInterval(0, 0);
            Rectangle rct = this.partsSelectTable.getCellRect(0, 0, true);
            this.partsSelectTable.scrollRectToVisible(rct);
            this.partsSelectTable.repaint();
        }
        this.partsSelectTable.requestFocus();
    }

    protected void onChangeColor(ImageSelectPanelEvent event) {
        for (ImageSelectPanelListener listener : this.listeners) {
            listener.onChangeColor(event);
        }
    }

    protected void onPreferences(ImageSelectPanelEvent event) {
        for (ImageSelectPanelListener listener : this.listeners) {
            listener.onPreferences(event);
        }
    }

    protected void onChange(ImageSelectPanelEvent event) {
        List<PartsIdentifier> selectedNews = this.getSelectedPartsIdentifiers();
        if (!((Object)selectedNews).equals(this.selectedPartsIdentifiers)) {
            this.selectedPartsIdentifiers = selectedNews;
            for (ImageSelectPanelListener listener : this.listeners) {
                listener.onChange(event);
            }
            this.onSelectChange(event);
        }
    }

    protected void onSelectChange(ImageSelectPanelEvent event) {
        PartsIdentifier selectedNew = this.getSelectedPartsIdentifier();
        if (!PartsIdentifier.equals(selectedNew, this.selectedPartsIdentifier)) {
            this.selectedPartsIdentifier = selectedNew;
            for (ImageSelectPanelListener listener : this.listeners) {
                listener.onSelectChange(event);
            }
        }
    }

    public List<PartsIdentifier> getSelectedPartsIdentifiers() {
        return this.partsSelectTableModel.getSelectedPartsIdentifiers();
    }

    public PartsIdentifier getSelectedPartsIdentifier() {
        int[] selRows = this.partsSelectTable.getSelectedRows();
        Arrays.sort(selRows);
        for (int selRow : selRows) {
            PartsSelectRow row = this.partsSelectTableModel.getRow(selRow);
            if (!row.isChecked()) continue;
            return row.getPartsIdentifier();
        }
        List<PartsIdentifier> checkedRows = this.getSelectedPartsIdentifiers();
        if (checkedRows.size() > 0) {
            return checkedRows.get(0);
        }
        return null;
    }

    public boolean isDeselectableSingleCategory() {
        return this.partsSelectTableModel.isDeselectableSingleCategory();
    }

    public void setDeselectableSingleCategory(boolean deselectable) {
        this.partsSelectTableModel.setDeselectableSingleCategory(deselectable);
    }

    public static class ImageSelectPanelEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public ImageSelectPanelEvent(ImageSelectPanel src) {
            super(src);
        }

        public ImageSelectPanel getImageSelectPanel() {
            return (ImageSelectPanel)this.getSource();
        }
    }

    public static interface ImageSelectPanelListener
    extends EventListener {
        public void onSelectChange(ImageSelectPanelEvent var1);

        public void onChange(ImageSelectPanelEvent var1);

        public void onChangeColor(ImageSelectPanelEvent var1);

        public void onPreferences(ImageSelectPanelEvent var1);
    }
}

