/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.util.ApplicationLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterDataDirectoryFile
extends AbstractCharacterDataArchiveFile {
    private static final Logger logger = ApplicationLogger.getLogger();
    protected File baseDir;

    @Override
    protected URL getContentURL(String name) throws IOException {
        return new File(this.baseDir, name).toURL();
    }

    @Override
    public Properties readExportProp() throws IOException {
        Properties exportInfoProp = new Properties();
        exportInfoProp.setProperty("EXPORT_SUBSET", "false");
        exportInfoProp.setProperty("EXPORT_PRESETS", "true");
        exportInfoProp.setProperty("EXPORT_PARTS_IMAGES", "true");
        return exportInfoProp;
    }

    @Override
    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getPartsImageContents(CharacterData characterData) {
        if (this.isOverlapped(characterData)) {
            return Collections.emptyList();
        }
        return super.getPartsImageContents(characterData);
    }

    @Override
    public Collection<AbstractCharacterDataArchiveFile.PartsImageContent> getPartsImageContentsLazy(CharacterData characterData) {
        if (this.isOverlapped(characterData)) {
            return Collections.emptyList();
        }
        return super.getPartsImageContentsLazy(characterData);
    }

    protected boolean isOverlapped(CharacterData characterData) {
        if (characterData == null) {
            return false;
        }
        URL docBase = characterData.getDocBase();
        if (docBase == null || !"file".equals(docBase.getProtocol())) {
            return false;
        }
        String folderPlace = File.separator;
        String basePath = new File(docBase.getPath()).getParent() + folderPlace;
        String sourcePath = this.baseDir.getPath() + folderPlace;
        boolean result = basePath.contains(sourcePath);
        logger.log(Level.FINE, "checkOverlapped: " + basePath + " * " + sourcePath + " :" + result);
        return result;
    }

    @Override
    public void close() throws IOException {
    }

    public CharacterDataDirectoryFile(File file) throws IOException {
        super(file);
        this.baseDir = file;
        this.load(this.baseDir, "");
        this.searchRootPrefix();
    }

    private void load(File dir, String prefix) {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            String name = file.getName();
            String entryName = prefix + name;
            if (file.isDirectory()) {
                this.load(file, entryName + "/");
                continue;
            }
            this.addEntry(new DirFileContent(file, entryName));
        }
    }

    protected static class DirFileContent
    implements AbstractCharacterDataArchiveFile.FileContent {
        private String entryName;
        private File entry;

        protected DirFileContent(File entry, String entryName) {
            this.entry = entry;
            this.entryName = entryName;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public long lastModified() {
            return this.entry.lastModified();
        }

        public InputStream openStream() throws IOException {
            return new FileInputStream(this.entry);
        }
    }
}

