/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.io.PNGFileImageHeader;
import charactermanaj.graphics.io.PNGFileImageHeaderReader;
import charactermanaj.model.CharacterData;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.PartsSet;
import charactermanaj.model.io.CharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.util.ApplicationLogger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCharacterDataArchiveFile
implements CharacterDataArchiveFile {
    private static final Logger logger = ApplicationLogger.getLogger();
    protected File archiveFile;
    protected String rootPrefix = "";
    protected HashMap<String, FileContent> entries = new HashMap();

    public String toString() {
        return "CharacterDataArchiveFile(file=" + this.archiveFile + ")";
    }

    protected AbstractCharacterDataArchiveFile(File archiveFile) {
        if (archiveFile == null) {
            throw new IllegalArgumentException();
        }
        this.archiveFile = archiveFile;
    }

    public File getArchiveFile() {
        return this.archiveFile;
    }

    protected void addEntry(FileContent fileContent) {
        if (fileContent == null) {
            throw new IllegalArgumentException();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, fileContent.getEntryName());
        }
        this.entries.put(fileContent.getEntryName(), fileContent);
    }

    protected URL getContentURL(String name) throws IOException {
        return new URL("jar:file:" + this.archiveFile.toURL().getPath() + "!/" + name);
    }

    @Override
    public boolean hasContent(String name) {
        return this.entries.containsKey(name);
    }

    public FileContent getContent(String name) {
        return this.entries.get(name);
    }

    @Override
    public String getRootPrefix() {
        return this.rootPrefix;
    }

    protected void searchRootPrefix() {
        HashSet<String> dirs = new HashSet<String>();
        for (String name : this.entries.keySet()) {
            int pos = name.indexOf(47);
            if (pos < 0) {
                this.rootPrefix = "";
                return;
            }
            if (pos < 0) continue;
            String dir = name.substring(0, pos + 1);
            dirs.add(dir);
        }
        if (dirs.size() == 1) {
            this.rootPrefix = (String)dirs.iterator().next();
            return;
        }
        this.rootPrefix = "";
    }

    public Map<String, FileContent> getFiles(String dir) {
        if (dir == null) {
            dir = "";
        }
        if (dir.length() > 0 && !dir.endsWith("/")) {
            dir = dir + "/";
        }
        if (dir.equals("/")) {
            dir = "";
        }
        HashMap<String, FileContent> files = new HashMap<String, FileContent>();
        int ep = dir.length();
        for (Map.Entry<String, FileContent> entry : this.entries.entrySet()) {
            String suffix;
            int sep;
            String name = entry.getKey();
            FileContent fileContent = entry.getValue();
            if (!name.startsWith(dir) || (sep = (suffix = name.substring(ep)).indexOf(47)) >= 0) continue;
            files.put(name, fileContent);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharacterData readCharacterData() throws IOException {
        CharacterData cd;
        CharacterDataPersistent.DocInfo docInfo;
        FileContent characterFile = this.entries.get(this.rootPrefix + "character.xml");
        if (characterFile == null) {
            return null;
        }
        URL docBase = this.getContentURL(this.rootPrefix + "character.xml");
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        InputStream is = characterFile.openStream();
        try {
            docInfo = persist.readDocumentType(is);
            logger.log(Level.INFO, docInfo == null ? "not xml document" : docInfo.toString());
        }
        finally {
            is.close();
        }
        if (docInfo == null || !"character".equals(docInfo.getFirstElementName())) {
            return null;
        }
        is = characterFile.openStream();
        try {
            cd = persist.loadCharacterDataFromXML(is, docBase, docInfo);
        }
        finally {
            is.close();
        }
        return cd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharacterData readCharacterINI() throws IOException {
        FileContent characterFile = null;
        characterFile = this.entries.get(this.rootPrefix + "character.ini");
        if (characterFile == null) {
            ArrayList<String> characterInis = new ArrayList<String>();
            for (Map.Entry<String, FileContent> entry : this.entries.entrySet()) {
                String entryName = entry.getKey();
                if (!entryName.endsWith("/character.ini")) continue;
                characterInis.add(entryName);
            }
            Collections.sort(characterInis);
            if (characterInis.size() > 0) {
                characterFile = this.entries.get(characterInis.get(0));
            }
        }
        if (characterFile == null) {
            return null;
        }
        URL docBase = this.getContentURL(this.rootPrefix + "character.ini");
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        CharacterData cd = persist.createDefaultCharacterData();
        cd.setDocBase(docBase);
        int siz_x = 0;
        int siz_y = 0;
        HashMap<String, String> plainPartsSet = new HashMap<String, String>();
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader(characterFile.openStream(), "MS932"));
            try {
                String line;
                int sectionMode = 0;
                while ((line = rd.readLine()) != null) {
                    String val;
                    String key;
                    if ((line = line.trim()).length() == 0) continue;
                    if (line.startsWith("[")) {
                        if (line.toLowerCase().equals("[size]")) {
                            sectionMode = 1;
                            continue;
                        }
                        if (line.toLowerCase().equals("[parts]")) {
                            sectionMode = 2;
                            continue;
                        }
                        sectionMode = 0;
                        continue;
                    }
                    int eqpos = line.indexOf(61);
                    if (eqpos >= 0) {
                        key = line.substring(0, eqpos).toLowerCase().trim();
                        val = line.substring(eqpos + 1);
                    } else {
                        key = line.toLowerCase().trim();
                        val = "";
                    }
                    if (sectionMode == 1) {
                        try {
                            if (key.equals("size_x")) {
                                siz_x = Integer.parseInt(val);
                                continue;
                            }
                            if (!key.equals("size_y")) continue;
                            siz_y = Integer.parseInt(val);
                        }
                        catch (RuntimeException ex) {
                            logger.log(Level.WARNING, "character.ini invalid. key=" + key + "/val=" + val, ex);
                        }
                        continue;
                    }
                    if (sectionMode != 2 || key.length() <= 0) continue;
                    plainPartsSet.put(key, val);
                }
            }
            finally {
                rd.close();
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "character.ini invalid.", ex);
            return null;
        }
        if (siz_x > 0 && siz_y > 0) {
            cd.setImageSize(new Dimension(siz_x, siz_y));
        }
        boolean existsPartsetParts = false;
        if (!plainPartsSet.isEmpty()) {
            PartsSet partsSet = new PartsSet("default", "default", true);
            for (Map.Entry entry : plainPartsSet.entrySet()) {
                PartsIdentifier partsIdentifier;
                String categoryId = (String)entry.getKey();
                String partsName = (String)entry.getValue();
                PartsCategory partsCategory = cd.getPartsCategory(categoryId);
                if (partsCategory == null) continue;
                if (partsName == null || partsName.length() == 0) {
                    partsIdentifier = null;
                } else {
                    partsIdentifier = new PartsIdentifier(partsCategory, partsName, partsName);
                    existsPartsetParts = true;
                }
                partsSet.appendParts(partsCategory, partsIdentifier, null);
            }
            if (!partsSet.isEmpty() && existsPartsetParts) {
                cd.addPartsSet(partsSet);
                cd.setDefaultPartsSetId("default");
            }
        }
        return cd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage readSamplePicture() throws IOException {
        BufferedImage pic;
        FileContent samplePictureFile = this.entries.get(this.rootPrefix + "preview.png");
        if (samplePictureFile == null) {
            Map<String, FileContent> files = this.getFiles(this.rootPrefix);
            samplePictureFile = files.get("preview.jpg");
            if (samplePictureFile == null) {
                samplePictureFile = files.get("preview.jpeg");
            }
            if (samplePictureFile == null) {
                for (Map.Entry<String, FileContent> entry : files.entrySet()) {
                    String name = entry.getKey();
                    if (!name.endsWith(".jpg") && !name.endsWith(".jpeg") && !name.endsWith(".png")) continue;
                    samplePictureFile = entry.getValue();
                    break;
                }
            }
        }
        if (samplePictureFile == null) {
            return null;
        }
        InputStream is = samplePictureFile.openStream();
        try {
            pic = ImageIO.read(is);
        }
        finally {
            is.close();
        }
        return pic;
    }

    @Override
    public String readReadMe() throws IOException {
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        ArrayList<FileContent> candiates = new ArrayList<FileContent>();
        Map<String, FileContent> files = this.getFiles(this.rootPrefix);
        block2: for (String findName : new String[]{"readme_" + lang + ".txt", "readme_" + lang, "readme.txt", "readme", null}) {
            for (Map.Entry<String, FileContent> entry : files.entrySet()) {
                String name = entry.getKey().toLowerCase();
                if (findName == null && name.endsWith(".txt")) {
                    candiates.add(entry.getValue());
                    continue block2;
                }
                if (!name.equals(findName)) continue;
                candiates.add(entry.getValue());
            }
        }
        if (candiates.isEmpty()) {
            return null;
        }
        for (FileContent file : candiates) {
            try {
                return this.readTextUTF16(file);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "read file failed. :" + file, ex);
            }
        }
        return null;
    }

    @Override
    public String readTextFile(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        FileContent content = this.entries.get(name);
        if (content == null) {
            return null;
        }
        return this.readTextUTF16(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readTextUTF16(FileContent content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream is = content.openStream();
        try {
            int ch;
            while ((ch = is.read()) != -1) {
                bos.write((byte)ch);
            }
        }
        finally {
            is.close();
        }
        byte[] buf = bos.toByteArray();
        String enc = null;
        if (buf.length >= 2) {
            if ((buf[0] & 0xFF) == 255 && (buf[1] & 0xFF) == 254) {
                enc = "UTF-16LE";
            } else if ((buf[0] & 0xFF) == 254 && (buf[1] & 0xFF) == 255) {
                enc = "UTF-16BE";
            }
        }
        if (enc == null && buf.length >= 3 && (buf[0] & 0xFF) == 239 && (buf[1] & 0xFF) == 187 && (buf[1] & 0xFF) == 191) {
            enc = "UTF-8";
        }
        if (enc == null) {
            enc = "JISAutoDetect";
        }
        StringBuilder str = new StringBuilder();
        InputStreamReader rd = new InputStreamReader((InputStream)new ByteArrayInputStream(buf), enc);
        try {
            int ch;
            while ((ch = rd.read()) != -1) {
                str.append((char)ch);
            }
        }
        finally {
            rd.close();
        }
        String line = str.toString();
        line = line.replace("\r\n", "\n");
        line = line.replace("\r", "\n");
        line = line.replace("\n", System.getProperty("line.separator"));
        return line;
    }

    protected Map<String, Collection<CategoryLayerPair>> getLayerDirs(CharacterData characterData, boolean enabledRootPrefix) {
        if (characterData == null) {
            return Collections.emptyMap();
        }
        String rootPrefix = this.getRootPrefix();
        HashMap<String, Collection<CategoryLayerPair>> layerDirs = new HashMap<String, Collection<CategoryLayerPair>>();
        for (PartsCategory partsCategory : characterData.getPartsCategories()) {
            for (Layer layer : partsCategory.getLayers()) {
                Collection<CategoryLayerPair> sameDirLayers;
                String dir = layer.getDir();
                if (!dir.endsWith("/")) {
                    dir = dir + "/";
                }
                if (enabledRootPrefix) {
                    dir = rootPrefix + dir;
                }
                if ((sameDirLayers = layerDirs.get(dir)) == null) {
                    sameDirLayers = new ArrayList<CategoryLayerPair>();
                    layerDirs.put(dir, sameDirLayers);
                }
                sameDirLayers.add(new CategoryLayerPair(partsCategory, layer));
            }
        }
        return layerDirs;
    }

    @Override
    public Collection<PartsImageContent> getPartsImageContents(CharacterData characterData) {
        Collection<PartsImageContent> results = this.getPartsImageContentsStrict(characterData);
        if (results.isEmpty()) {
            results = this.getPartsImageContentsLazy(characterData);
        }
        return results;
    }

    public Collection<PartsImageContent> getPartsImageContentsStrict(CharacterData characterData) {
        final Map<String, Collection<CategoryLayerPair>> layerDirMap = this.getLayerDirs(characterData, true);
        CategoryLayerPairResolveStrategy strategy = new CategoryLayerPairResolveStrategy(){

            @Override
            public Collection<CategoryLayerPair> resolveCategoryLayerPairs(String dir) {
                Collection categoryLayerPairs = (Collection)layerDirMap.get(dir);
                if (categoryLayerPairs == null || categoryLayerPairs.isEmpty()) {
                    return null;
                }
                return categoryLayerPairs;
            }
        };
        return this.getPartsImageContents(strategy);
    }

    public Collection<PartsImageContent> getPartsImageContentsLazy(CharacterData characterData) {
        final Map<String, Collection<CategoryLayerPair>> layerDirMap = this.getLayerDirs(characterData, false);
        CategoryLayerPairResolveStrategy strategy = new CategoryLayerPairResolveStrategy(){

            @Override
            public Collection<CategoryLayerPair> resolveCategoryLayerPairs(String dir) {
                dir = dir == null ? "" : dir.toLowerCase();
                for (Map.Entry entry : layerDirMap.entrySet()) {
                    String dirSuffix = ((String)entry.getKey()).toLowerCase();
                    Collection categoryLayerPairs = (Collection)entry.getValue();
                    if (!dir.endsWith(dirSuffix)) continue;
                    return categoryLayerPairs;
                }
                return null;
            }
        };
        return this.getPartsImageContents(strategy);
    }

    protected Collection<PartsImageContent> getPartsImageContents(CategoryLayerPairResolveStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<PartsImageContent> results = new ArrayList<PartsImageContent>();
        for (Map.Entry<String, FileContent> entry : this.entries.entrySet()) {
            String dir;
            Collection<CategoryLayerPair> categoryLayerPairs;
            String lastName;
            String name = entry.getKey();
            FileContent fileContent = entry.getValue();
            String[] split = name.split("/");
            if (split.length < 2 || !(lastName = split[split.length - 1]).toLowerCase().endsWith(".png") || (categoryLayerPairs = strategy.resolveCategoryLayerPairs(dir = name.substring(0, name.length() - lastName.length()))) == null) continue;
            PNGFileImageHeader pngFileHeader = this.readPNGFileHeader(fileContent);
            if (pngFileHeader == null) {
                logger.log(Level.WARNING, "invalid png: " + name);
                continue;
            }
            int extpos = lastName.lastIndexOf(46);
            String partsName = lastName.substring(0, extpos);
            PartsImageContent partsImageContent = new PartsImageContent(fileContent, categoryLayerPairs, lastName, partsName, pngFileHeader);
            results.add(partsImageContent);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PNGFileImageHeader readPNGFileHeader(FileContent fileContent) {
        PNGFileImageHeaderReader pngHeaderReader = PNGFileImageHeaderReader.getInstance();
        PNGFileImageHeader pngFileHeader = null;
        try {
            InputStream is = fileContent.openStream();
            try {
                pngFileHeader = pngHeaderReader.readHeader(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "not png header. " + fileContent, ex);
            pngFileHeader = null;
        }
        return pngFileHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartsManageData getPartsManageData() throws IOException {
        PartsManageData partsManageData;
        FileContent content = this.entries.get(this.rootPrefix + "parts-info.xml");
        if (content == null) {
            return new PartsManageData();
        }
        InputStream is = content.openStream();
        try {
            CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
            partsManageData = persist.loadPartsManageData(is);
        }
        finally {
            is.close();
        }
        return partsManageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties readExportProp() throws IOException {
        FileContent content = this.entries.get(this.rootPrefix + "export-info.xml");
        if (content == null) {
            return null;
        }
        Properties prop = new Properties();
        InputStream is = content.openStream();
        try {
            prop.loadFromXML(is);
        }
        finally {
            is.close();
        }
        return prop;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface CategoryLayerPairResolveStrategy {
        public Collection<CategoryLayerPair> resolveCategoryLayerPairs(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PartsImageContent
    implements FileContent {
        private final FileContent fileContent;
        private final Collection<CategoryLayerPair> categoryLayerPairs;
        private final String dirName;
        private final String partsName;
        private final String fileName;
        private final PNGFileImageHeader pngFileImageHeader;

        protected PartsImageContent(FileContent fileContent, Collection<CategoryLayerPair> categoryLayerPairs, String fileName, String partsName, PNGFileImageHeader pngFileImageHeader) {
            if (fileContent == null || categoryLayerPairs == null || categoryLayerPairs.isEmpty() || fileName == null || partsName == null || pngFileImageHeader == null) {
                throw new IllegalArgumentException();
            }
            this.fileContent = fileContent;
            this.categoryLayerPairs = Collections.unmodifiableCollection(categoryLayerPairs);
            this.fileName = fileName;
            this.partsName = partsName;
            this.pngFileImageHeader = pngFileImageHeader;
            CategoryLayerPair categoryLayerPair = categoryLayerPairs.iterator().next();
            this.dirName = categoryLayerPair.getLayer().getDir();
        }

        public int hashCode() {
            return this.getEntryName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj instanceof PartsImageContent) {
                return this.getEntryName().equals(((PartsImageContent)obj).getEntryName());
            }
            return false;
        }

        public Collection<CategoryLayerPair> getCategoryLayerPairs() {
            return this.categoryLayerPairs;
        }

        public String getDirName() {
            return this.dirName;
        }

        @Override
        public String getEntryName() {
            return this.fileContent.getEntryName();
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getPartsName() {
            return this.partsName;
        }

        public PNGFileImageHeader getPngFileImageHeader() {
            return this.pngFileImageHeader;
        }

        @Override
        public long lastModified() {
            return this.fileContent.lastModified();
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.fileContent.openStream();
        }

        public String toString() {
            return this.fileContent.getEntryName();
        }
    }

    public static final class CategoryLayerPair {
        private PartsCategory partsCategory;
        private Layer layer;

        public CategoryLayerPair(PartsCategory partsCategory, Layer layer) {
            if (partsCategory == null || layer == null) {
                throw new IllegalArgumentException();
            }
            this.partsCategory = partsCategory;
            this.layer = layer;
        }

        public int hashCode() {
            return this.partsCategory.hashCode() ^ this.layer.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj instanceof CategoryLayerPair) {
                CategoryLayerPair o = (CategoryLayerPair)obj;
                return this.partsCategory.equals(o.partsCategory) && this.layer.equals(o.layer);
            }
            return false;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public PartsCategory getPartsCategory() {
            return this.partsCategory;
        }

        public String toString() {
            return "(" + this.partsCategory + ":" + this.layer + ")";
        }
    }

    public static interface FileContent {
        public String getEntryName();

        public long lastModified();

        public InputStream openStream() throws IOException;
    }
}

