/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.ImageCache;
import charactermanaj.graphics.io.ImageLoaderImpl;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.ImageResourceCacheKey;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ImageCachedLoader
extends ImageLoaderImpl {
    private ImageCache<ImageResourceCacheKey> caches = new ImageCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage load(ImageResource imageResource) throws IOException {
        if (imageResource == null) {
            throw new IllegalArgumentException();
        }
        ImageResourceCacheKey key = new ImageResourceCacheKey(imageResource);
        ImageCache<ImageResourceCacheKey> imageCache = this.caches;
        synchronized (imageCache) {
            BufferedImage img = this.caches.get(key);
            if (img == null) {
                img = super.load(imageResource);
                this.caches.set(key, img);
                this.caches.unlockImages();
            }
            return img;
        }
    }
}

