/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCache<K> {
    private HashMap<K, BufferedImage> lockedImages = new HashMap();
    private HashMap<K, SoftReference<BufferedImage>> caches = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage get(K key) {
        if (key == null) {
            return null;
        }
        HashMap<K, SoftReference<BufferedImage>> hashMap = this.caches;
        synchronized (hashMap) {
            SoftReference<BufferedImage> ref = this.caches.get(key);
            BufferedImage img = null;
            if (ref != null && (img = ref.get()) == null) {
                this.caches.remove(key);
            }
            return img;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(K key, BufferedImage img) {
        if (key == null) {
            return;
        }
        HashMap<K, SoftReference<BufferedImage>> hashMap = this.caches;
        synchronized (hashMap) {
            if (img == null) {
                this.caches.remove(key);
            } else {
                this.lockedImages.put(key, img);
                this.caches.put(key, new SoftReference<BufferedImage>(img));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockImages() {
        HashMap<K, SoftReference<BufferedImage>> hashMap = this.caches;
        synchronized (hashMap) {
            this.lockedImages.clear();
        }
    }
}

